/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgresql.util.PGtokenizer;

public class Point
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final boolean CUTINTS = true;
    public double x;
    public double y;
    public double z;
    public double m = 0.0;

    public int hashCode() {
        return super.hashCode() ^ Point.hashCode(this.x) ^ Point.hashCode(this.y) ^ Point.hashCode(this.z) ^ Point.hashCode(this.m);
    }

    public static int hashCode(double value) {
        long v = Double.doubleToLongBits(value);
        return (int)(v ^ v >>> 32);
    }

    protected boolean equalsintern(Geometry otherg) {
        Point other = (Point)otherg;
        return this.equals(other);
    }

    public static boolean double_equals(double a, double b) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        return a == b;
    }

    public final boolean equals(Point other) {
        boolean xequals = Point.double_equals(this.x, other.x);
        boolean yequals = Point.double_equals(this.y, other.y);
        boolean zequals = this.dimension == 2 || Point.double_equals(this.z, other.z);
        boolean mequals = !this.haveMeasure || Point.double_equals(this.m, other.m);
        boolean result = xequals && yequals && zequals && mequals;
        return result;
    }

    public Point getPoint(int index) {
        if (index == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Point only has a single Point! " + index);
    }

    public Point getFirstPoint() {
        return this;
    }

    public Point getLastPoint() {
        return this;
    }

    public int numPoints() {
        return 1;
    }

    public Point() {
        super(1);
    }

    public Point(double x, double y, double z) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = 3;
    }

    public Point(double x, double y) {
        this();
        this.x = x;
        this.y = y;
        this.z = 0.0;
        this.dimension = 2;
    }

    public Point(String value) throws SQLException {
        this(value, false);
    }

    protected Point(String value, boolean haveM) throws SQLException {
        this();
        value = this.initSRID(value);
        if (value.indexOf("POINTM") == 0) {
            haveM = true;
            value = value.substring(6).trim();
        } else if (value.indexOf("POINT") == 0) {
            value = value.substring(5).trim();
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value), ' ');
        try {
            this.x = Double.valueOf(t.getToken(0));
            this.y = Double.valueOf(t.getToken(1));
            if (t.getSize() == 3 && !(haveM |= t.getSize() == 4) || t.getSize() == 4) {
                this.z = Double.valueOf(t.getToken(2));
                this.dimension = 3;
            } else {
                this.dimension = 2;
            }
            if (haveM) {
                this.m = Double.valueOf(t.getToken(this.dimension));
            }
        }
        catch (NumberFormatException e) {
            throw new SQLException("Error parsing Point: " + e.toString());
        }
        this.haveMeasure = haveM;
    }

    public void innerWKT(StringBuffer sb) {
        sb.append(this.x);
        Point.cutint(sb);
        sb.append(' ');
        sb.append(this.y);
        Point.cutint(sb);
        if (this.dimension == 3) {
            sb.append(' ');
            sb.append(this.z);
            Point.cutint(sb);
        }
        if (this.haveMeasure) {
            sb.append(' ');
            sb.append(this.m);
            Point.cutint(sb);
        }
    }

    private static void cutint(StringBuffer sb) {
        int l = sb.length() - 2;
        if (sb.charAt(l + 1) == '0' && sb.charAt(l) == '.') {
            sb.setLength(l);
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setM(double m) {
        this.haveMeasure = true;
        this.m = m;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public double distance(Point other) {
        if (this.dimension != other.dimension) {
            throw new IllegalArgumentException("Points have different dimensions!");
        }
        double tx = this.x - other.x;
        switch (this.dimension) {
            case 1: {
                return Math.sqrt(tx * tx);
            }
            case 2: {
                double ty = this.y - other.y;
                return Math.sqrt(tx * tx + ty * ty);
            }
            case 3: {
                double ty = this.y - other.y;
                double tz = this.z - other.z;
                return Math.sqrt(tx * tx + ty * ty + tz * tz);
            }
        }
        throw new IllegalArgumentException("Illegal dimension of Point" + this.dimension);
    }

    public boolean checkConsistency() {
        return !(!super.checkConsistency() || this.dimension != 3 && this.z != 0.0 || !this.haveMeasure && this.m != 0.0);
    }
}

