/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public abstract class PGboxbase
extends PGobject {
    private static final long serialVersionUID = 256L;
    protected Point llb;
    protected Point urt;

    public abstract String getPrefix();

    public abstract String getPGtype();

    public PGboxbase() {
        this.setType(this.getPGtype());
    }

    public PGboxbase(Point llb, Point urt) {
        this();
        this.llb = llb;
        this.urt = urt;
    }

    public PGboxbase(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public void setValue(String value) throws SQLException {
        String myPrefix;
        int srid = 0;
        if ((value = value.trim()).startsWith("SRID=")) {
            String[] temp = PGgeometry.splitSRID(value);
            value = temp[1].trim();
            srid = Geometry.parseSRID(Integer.parseInt(temp[0].substring(5)));
        }
        if (value.startsWith(myPrefix = this.getPrefix())) {
            value = value.substring(myPrefix.length()).trim();
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara((String)value), ',');
        this.llb = new Point(t.getToken(0));
        this.urt = new Point(t.getToken(1));
        if (srid != 0) {
            this.llb.setSrid(srid);
            this.urt.setSrid(srid);
        }
    }

    public String getValue() {
        StringBuffer sb = new StringBuffer();
        this.outerWKT(sb);
        return sb.toString();
    }

    private void outerWKT(StringBuffer sb) {
        sb.append(this.getPrefix());
        sb.append('(');
        this.llb.innerWKT(sb);
        sb.append(',');
        this.urt.innerWKT(sb);
        sb.append(')');
    }

    public String toString() {
        return this.getValue();
    }

    public Point getLLB() {
        return this.llb;
    }

    public Point getURT() {
        return this.urt;
    }

    public boolean equals(Object other) {
        if (other instanceof PGboxbase) {
            PGboxbase otherbox = (PGboxbase)((Object)other);
            return PGboxbase.compareLazyDim(this.llb, otherbox.llb) && PGboxbase.compareLazyDim(this.urt, otherbox.urt);
        }
        return false;
    }

    protected static boolean compareLazyDim(Point first, Point second) {
        return !(first.x != second.x || first.y != second.y || (first.dimension != 2 && first.z != 0.0 || second.dimension != 2 && second.z != 0.0) && first.z != second.z);
    }

    public Object clone() {
        PGboxbase obj = this.newInstance();
        obj.llb = this.llb;
        obj.urt = this.urt;
        obj.setType(this.type);
        return obj;
    }

    protected abstract PGboxbase newInstance();
}

