package cielo.printer.client.di.contract

import android.graphics.Bitmap

interface PrinterClientContract {

    fun bind()

    fun unbind()

    fun printText(string: String)

    fun printText(string: Array<String>, style: Map<String, Int>)

    fun printText(string: Array<String>, style: List<Map<String, Int>>)

    fun printText(string: String, style: Map<String, Int>)

    fun printBitmap(bitmap: Bitmap)

    fun printBitmap(bitmap: Bitmap, style: Map<String, Int>)

    fun setPrinterListener(printerListener: PrinterServiceListener)

    fun restartCounterLinesPrinted(printerListener: PrinterOperationListener)

    fun getCounterLinesPrinted(printerListener: PrinterOperationListener)

    fun printQrCode(text: String, align: Int, size: Int)

    fun printBarCode(text: String, align: Int, width: Int, height: Int, showContent: Boolean)

    interface PrinterServiceListener {

        fun onSuccess()

        fun onError(e: Throwable)

        fun onWithoutPaper()

    }

    interface PrinterOperationListener {

        fun onSuccess()

        fun onResult(linesAmount: Long)

        fun onError(e: Throwable)

    }

}
