/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import java.util.Properties;

public class VersionUtil {
    public static String getVersionOfArtifact(Class<?> aClass) {
        String moduleVersion = VersionUtil.getVersionOfClassByModule(aClass);
        if (moduleVersion != null) {
            return moduleVersion;
        }
        Package pkg = aClass.getPackage();
        if (pkg == null) {
            return null;
        }
        return pkg.getImplementationVersion();
    }

    public static String nonNull(String input) {
        if (input == null) {
            return "?";
        }
        return input;
    }

    private static String getVersionOfClassByModule(Class<?> aClass) {
        Module module = aClass.getModule();
        if (module == null) {
            return null;
        }
        ModuleDescriptor md = module.getDescriptor();
        if (md == null) {
            return null;
        }
        Optional<String> opt = md.rawVersion();
        return opt.orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getExpectedVersionOfDependeeByProperties(Class<?> dependentClass, String propertiesFileName, String dependeeNameAsKey) {
        Properties props = new Properties();
        try (InputStream is = dependentClass.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (is != null) {
                props.load(is);
                String string2 = props.getProperty(dependeeNameAsKey);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void checkForVersionEquality(Context context, Class<?> dependentClass, Class<?> dependeeClass, String dependentName, String dependeeName) {
        String dependentVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependentClass));
        String dependeeVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependeeClass));
        VersionUtil.addFoundVersionStatus(context, dependentName, dependentVersion);
        if (dependentVersion.equals("?") || !dependentVersion.equals(dependeeVersion)) {
            VersionUtil.addFoundVersionStatus(context, dependeeName, dependeeVersion);
            String discrepancyMsg = String.format("Versions of %s and %s are different!", dependeeName, dependentName);
            context.getStatusManager().add(new WarnStatus(discrepancyMsg, context));
        }
    }

    private static void addFoundVersionStatus(Context context, String name, String version) {
        String foundDependent = String.format("Found %s version %s", name, version);
        context.getStatusManager().add(new InfoStatus(foundDependent, context));
    }

    private static String nameToFilename(String name) {
        return name + "-dependees.properties";
    }

    public static void compareExpectedAndFoundVersion(Context context, Class<?> dependentClass, Class<?> dependeeClass, String dependentName, String dependeeName) {
        String expectedDependeeVersion = VersionUtil.nonNull(VersionUtil.getExpectedVersionOfDependeeByProperties(dependentClass, VersionUtil.nameToFilename(dependentName), dependeeName));
        String actualDependeeVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependeeClass));
        String dependentVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependentClass));
        VersionUtil.addFoundVersionStatus(context, dependeeName, actualDependeeVersion);
        VersionUtil.addFoundVersionStatus(context, dependentName, dependentVersion);
        if (!expectedDependeeVersion.equals(actualDependeeVersion)) {
            String discrepancyMsg = String.format("Expected version of %s is %s but found %s", dependeeName, expectedDependeeVersion, actualDependeeVersion);
            context.getStatusManager().add(new WarnStatus(discrepancyMsg, context));
        }
    }
}

