/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.contrib.mongodb.MongoDBAppenderBase;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.Date;

public class MongoDBLoggingEventAppender
extends MongoDBAppenderBase<ILoggingEvent> {
    private boolean includeCallerData;

    protected BasicDBObject toMongoDocument(ILoggingEvent event) {
        BasicDBObject logEntry = new BasicDBObject();
        logEntry.append("message", (Object)event.getFormattedMessage());
        logEntry.append("logger", (Object)event.getLoggerName());
        logEntry.append("thread", (Object)event.getThreadName());
        logEntry.append("timestamp", (Object)new Date(event.getTimeStamp()));
        logEntry.append("level", (Object)event.getLevel().toString());
        if (event.getMDCPropertyMap() != null && !event.getMDCPropertyMap().isEmpty()) {
            logEntry.append("mdc", (Object)event.getMDCPropertyMap());
        }
        if (this.includeCallerData) {
            logEntry.append("callerData", (Object)this.toDocument(event.getCallerData()));
        }
        if (event.getArgumentArray() != null && event.getArgumentArray().length > 0) {
            logEntry.append("arguments", (Object)event.getArgumentArray());
        }
        this.appendThrowableIfAvailable(logEntry, event);
        return logEntry;
    }

    private BasicDBList toDocument(StackTraceElement[] callerData) {
        BasicDBList dbList = new BasicDBList();
        for (StackTraceElement ste : callerData) {
            dbList.add((Object)new BasicDBObject().append("file", (Object)ste.getFileName()).append("class", (Object)ste.getClassName()).append("method", (Object)ste.getMethodName()).append("line", (Object)ste.getLineNumber()).append("native", (Object)ste.isNativeMethod()));
        }
        return dbList;
    }

    private void appendThrowableIfAvailable(BasicDBObject doc, ILoggingEvent event) {
        if (event.getThrowableProxy() != null) {
            BasicDBObject val = this.toMongoDocument(event.getThrowableProxy());
            doc.append("throwable", (Object)val);
        }
    }

    private BasicDBObject toMongoDocument(IThrowableProxy throwable) {
        BasicDBObject throwableDoc = new BasicDBObject();
        throwableDoc.append("class", (Object)throwable.getClassName());
        throwableDoc.append("message", (Object)throwable.getMessage());
        throwableDoc.append("stackTrace", (Object)this.toSteArray(throwable));
        if (throwable.getCause() != null) {
            throwableDoc.append("cause", (Object)this.toMongoDocument(throwable.getCause()));
        }
        return throwableDoc;
    }

    private String[] toSteArray(IThrowableProxy throwableProxy) {
        StackTraceElementProxy[] elementProxies = throwableProxy.getStackTraceElementProxyArray();
        int totalFrames = elementProxies.length - throwableProxy.getCommonFrames();
        String[] stackTraceElements = new String[totalFrames];
        for (int i = 0; i < totalFrames; ++i) {
            stackTraceElements[i] = elementProxies[i].getStackTraceElement().toString();
        }
        return stackTraceElements;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }
}

