/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.contrib.mongodb.MongoDBAppenderBase;
import com.mongodb.BasicDBObject;
import java.util.Date;

public class MongoDBAccessEventAppender
extends MongoDBAppenderBase<IAccessEvent> {
    private boolean serverName = true;
    private boolean requestUri = true;
    private boolean requestProtocol = true;
    private boolean requestMethod = true;
    private boolean requestPostContent = true;
    private boolean requestSessionId = true;
    private boolean requestUserAgent = true;
    private boolean requestReferer = true;
    private boolean remoteHost = true;
    private boolean remoteUser = true;
    private boolean remoteAddr = true;
    private boolean responseContentLength = true;
    private boolean responseStatusCode = true;

    protected BasicDBObject toMongoDocument(IAccessEvent iAccessEvent) {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.append("timeStamp", (Object)new Date(iAccessEvent.getTimeStamp()));
        if (this.serverName) {
            basicDBObject.append("serverName", (Object)iAccessEvent.getServerName());
        }
        this.addRemote(basicDBObject, iAccessEvent);
        this.addRequest(basicDBObject, iAccessEvent);
        this.addResponse(basicDBObject, iAccessEvent);
        return basicDBObject;
    }

    private void addRemote(BasicDBObject basicDBObject, IAccessEvent iAccessEvent) {
        BasicDBObject basicDBObject2 = new BasicDBObject();
        String string = iAccessEvent.getRemoteHost();
        if (this.remoteHost && string != null) {
            basicDBObject2.append("host", (Object)string);
        }
        String string2 = iAccessEvent.getRemoteUser();
        if (this.remoteUser && string2 != null && !string2.equals("-")) {
            basicDBObject2.append("user", (Object)string2);
        }
        String string3 = iAccessEvent.getRemoteAddr();
        if (this.remoteAddr && string3 != null) {
            basicDBObject2.append("addr", (Object)string3);
        }
        if (!basicDBObject2.isEmpty()) {
            basicDBObject.put("remote", (Object)basicDBObject2);
        }
    }

    private void addRequest(BasicDBObject basicDBObject, IAccessEvent iAccessEvent) {
        BasicDBObject basicDBObject2 = new BasicDBObject();
        String string = iAccessEvent.getRequestURI();
        if (this.requestUri && string != null && !string.equals("-")) {
            basicDBObject2.append("uri", (Object)string);
        }
        String string2 = iAccessEvent.getProtocol();
        if (this.requestProtocol && string2 != null) {
            basicDBObject2.append("protocol", (Object)string2);
        }
        String string3 = iAccessEvent.getMethod();
        if (this.requestMethod && string3 != null) {
            basicDBObject2.append("method", (Object)string3);
        }
        String string4 = iAccessEvent.getRequestContent();
        if (this.requestPostContent && string4 != null && !string4.equals("")) {
            basicDBObject2.append("postContent", (Object)string4);
        }
        String string5 = iAccessEvent.getCookie("JSESSIONID");
        if (this.requestSessionId && string5 != null && !string5.equals("-")) {
            basicDBObject2.append("sessionId", (Object)string5);
        }
        String string6 = iAccessEvent.getRequestHeader("User-Agent");
        if (this.requestUserAgent && string6 != null && !string6.equals("-")) {
            basicDBObject2.append("userAgent", (Object)string6);
        }
        String string7 = iAccessEvent.getRequestHeader("Referer");
        if (this.requestReferer && string7 != null && !string7.equals("-")) {
            basicDBObject2.append("referer", (Object)string7);
        }
        if (!basicDBObject2.isEmpty()) {
            basicDBObject.put("request", (Object)basicDBObject2);
        }
    }

    private void addResponse(BasicDBObject basicDBObject, IAccessEvent iAccessEvent) {
        BasicDBObject basicDBObject2 = new BasicDBObject();
        if (this.responseContentLength) {
            basicDBObject2.append("contentLength", (Object)iAccessEvent.getContentLength());
        }
        if (this.responseStatusCode) {
            basicDBObject2.append("statusCode", (Object)iAccessEvent.getStatusCode());
        }
        if (!basicDBObject2.isEmpty()) {
            basicDBObject.append("response", (Object)basicDBObject2);
        }
    }

    public void setServerName(boolean bl) {
        this.serverName = bl;
    }

    public void setRequestUri(boolean bl) {
        this.requestUri = bl;
    }

    public void setRequestProtocol(boolean bl) {
        this.requestProtocol = bl;
    }

    public void setRequestMethod(boolean bl) {
        this.requestMethod = bl;
    }

    public void setRequestPostContent(boolean bl) {
        this.requestPostContent = bl;
    }

    public void setRequestSessionId(boolean bl) {
        this.requestSessionId = bl;
    }

    public void setRequestUserAgent(boolean bl) {
        this.requestUserAgent = bl;
    }

    public void setRequestReferer(boolean bl) {
        this.requestReferer = bl;
    }

    public void setRemoteHost(boolean bl) {
        this.remoteHost = bl;
    }

    public void setRemoteUser(boolean bl) {
        this.remoteUser = bl;
    }

    public void setRemoteAddr(boolean bl) {
        this.remoteAddr = bl;
    }

    public void setResponseContentLength(boolean bl) {
        this.responseContentLength = bl;
    }

    public void setResponseStatusCode(boolean bl) {
        this.responseStatusCode = bl;
    }
}

