/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.jackson;

import ch.qos.logback.contrib.json.JsonFormatter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class JacksonJsonFormatter
implements JsonFormatter {
    public static final int BUFFER_SIZE = 512;
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean prettyPrint = false;

    public String toJsonString(Map m) throws IOException {
        StringWriter writer = new StringWriter(512);
        JsonGenerator generator = this.objectMapper.getFactory().createJsonGenerator((Writer)writer);
        if (this.isPrettyPrint()) {
            generator.useDefaultPrettyPrinter();
        }
        this.objectMapper.writeValue(generator, (Object)m);
        writer.flush();
        return writer.toString();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }
}

