/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;

class HeaderUtil {
    HeaderUtil() {
    }

    static Map<String, String> buildHeaderMap(HttpFields headers) {
        TreeMap<String, String> requestHeaderMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (HttpField httpField : headers) {
            String existing = (String)requestHeaderMap.get(httpField.getName());
            String value = HeaderUtil.combine(existing, httpField.getValue());
            requestHeaderMap.put(httpField.getName(), value);
        }
        return requestHeaderMap;
    }

    private static String combine(String existing, String field) {
        if (existing == null) {
            return field;
        }
        return existing + "," + field;
    }
}

