/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import ch.qos.cal10n.util.CAL10NResourceBundle;
import ch.qos.cal10n.util.CAL10NResourceBundleFinder;
import ch.qos.cal10n.util.IAnnotationExtractor;
import ch.qos.cal10n.util.MiscUtil;
import ch.qos.cal10n.verifier.CAL10NError;
import ch.qos.cal10n.verifier.ErrorFactory;
import ch.qos.cal10n.verifier.IMessageKeyVerifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageKeyVerifierBase
implements IMessageKeyVerifier {
    final String enumTypeAsStr;
    final IAnnotationExtractor annotationExtractor;

    protected MessageKeyVerifierBase(String enumTypeAsStr, IAnnotationExtractor annotationExtractor) {
        this.enumTypeAsStr = enumTypeAsStr;
        this.annotationExtractor = annotationExtractor;
    }

    @Override
    public String getEnumTypeAsStr() {
        return this.enumTypeAsStr;
    }

    protected String extractCharsetForLocale(Locale locale) {
        return this.annotationExtractor.extractCharset(locale);
    }

    protected abstract List<String> extractKeysInEnum();

    @Override
    public String[] getLocaleNames() {
        String[] localeNameArray = this.annotationExtractor.extractLocaleNames();
        return localeNameArray;
    }

    @Override
    public String getBaseName() {
        String rbName = this.annotationExtractor.getBaseName();
        return rbName;
    }

    @Override
    public List<CAL10NError> verify(Locale locale) {
        ArrayList<CAL10NError> errorList = new ArrayList<CAL10NError>();
        String baseName = this.getBaseName();
        if (baseName == null) {
            errorList.add(new CAL10NError(CAL10NError.ErrorType.MISSING_BN_ANNOTATION, "", this.enumTypeAsStr, locale, ""));
            return errorList;
        }
        String charset = this.extractCharsetForLocale(locale);
        CAL10NResourceBundle rb = CAL10NResourceBundleFinder.getBundle(this.getClass().getClassLoader(), baseName, locale, charset);
        ErrorFactory errorFactory = new ErrorFactory(this.enumTypeAsStr, locale, baseName);
        if (rb == null) {
            errorList.add(errorFactory.buildError(CAL10NError.ErrorType.FAILED_TO_FIND_RB, ""));
            return errorList;
        }
        Set<String> rbKeySet = this.buildKeySetFromEnumeration(((ResourceBundle)rb).getKeys());
        if (rbKeySet.size() == 0) {
            errorList.add(errorFactory.buildError(CAL10NError.ErrorType.EMPTY_RB, ""));
        }
        if (errorList.size() != 0) {
            return errorList;
        }
        List<String> enumKeys = this.extractKeysInEnum();
        if (enumKeys.size() == 0) {
            errorList.add(errorFactory.buildError(CAL10NError.ErrorType.EMPTY_ENUM, ""));
        }
        for (String enumKey : enumKeys) {
            if (rbKeySet.contains(enumKey)) {
                rbKeySet.remove(enumKey);
                continue;
            }
            errorList.add(errorFactory.buildError(CAL10NError.ErrorType.ABSENT_IN_RB, enumKey));
        }
        for (String rbKey : rbKeySet) {
            errorList.add(errorFactory.buildError(CAL10NError.ErrorType.ABSENT_IN_ENUM, rbKey));
        }
        return errorList;
    }

    @Override
    public List<String> typeIsolatedVerify(Locale locale) {
        List<CAL10NError> errorList = this.verify(locale);
        ArrayList<String> strList = new ArrayList<String>();
        for (CAL10NError error : errorList) {
            strList.add(error.toString());
        }
        return strList;
    }

    protected Set<String> buildKeySetFromEnumeration(Enumeration<String> e) {
        HashSet<String> set = new HashSet<String>();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            set.add(s);
        }
        return set;
    }

    @Override
    public List<CAL10NError> verifyAllLocales() {
        ArrayList<CAL10NError> errorList = new ArrayList<CAL10NError>();
        String[] localeNameArray = this.getLocaleNames();
        ErrorFactory errorFactory = new ErrorFactory(this.enumTypeAsStr, null, this.getBaseName());
        if (localeNameArray == null || localeNameArray.length == 0) {
            errorList.add(errorFactory.buildError(CAL10NError.ErrorType.MISSING_LOCALE_DATA_ANNOTATION, "*"));
            return errorList;
        }
        for (String localeName : localeNameArray) {
            Locale locale = MiscUtil.toLocale(localeName);
            List<CAL10NError> tmpList = this.verify(locale);
            errorList.addAll(tmpList);
        }
        return errorList;
    }
}

