/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CAL10NPropertyResourceBundle
extends PropertyResourceBundle {
    static long CHECK_DELAY = 600000L;
    File hostFile;
    volatile long nextCheck;
    long lastModified;

    public CAL10NPropertyResourceBundle(InputStream is, File file) throws IOException {
        super(is);
        this.hostFile = file;
        this.nextCheck = System.currentTimeMillis() + CHECK_DELAY;
    }

    public void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    public boolean hasChanged() {
        if (this.hostFile == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextCheck) {
            return false;
        }
        this.nextCheck = now + CHECK_DELAY;
        if (this.lastModified != this.hostFile.lastModified()) {
            this.lastModified = this.hostFile.lastModified();
            return true;
        }
        return false;
    }

    public void resetCheckTimes() {
        this.nextCheck = 0L;
        this.lastModified = 0L;
    }
}

