/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.analysis.solver;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.BiFunction;

public class NewtonRaphsonSolver {
    private BiFunction<BigDecimal, MathContext, BigDecimal> function;
    private BiFunction<BigDecimal, MathContext, BigDecimal> functionFirstDerivative;
    private int maxIterations = 100;

    public NewtonRaphsonSolver(BiFunction<BigDecimal, MathContext, BigDecimal> function, BiFunction<BigDecimal, MathContext, BigDecimal> functionFirstDerivative) {
        this.function = function;
        this.functionFirstDerivative = functionFirstDerivative;
    }

    public NewtonRaphsonSolver withMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public BigDecimal solve(BigDecimal initial, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 5, mathContext.getRoundingMode());
        BigDecimal result = this.solveInternal(initial, mc);
        if (result != null && mathContext.getPrecision() != 0) {
            result = BigDecimalMath.roundAbsolutePrecision(result, mathContext);
        }
        return result;
    }

    private BigDecimal solveInternal(BigDecimal initial, MathContext mc) {
        BigDecimal epsilon = BigDecimal.ONE.scaleByPowerOfTen(-mc.getPrecision() + 2);
        BigDecimal currentX = initial;
        BigDecimal currentY = this.function.apply(currentX, mc);
        BigDecimal currentFirstDerivativeY = this.functionFirstDerivative.apply(currentX, mc);
        int iteration = 0;
        while (iteration++ < this.maxIterations) {
            System.out.println("  " + iteration + " : x=" + currentX + " y=" + currentY + " y'=" + currentFirstDerivativeY);
            if (currentY == null || currentFirstDerivativeY == null) {
                return null;
            }
            if (currentY.signum() == 0) {
                return currentX;
            }
            if (currentFirstDerivativeY.signum() == 0) {
                return null;
            }
            BigDecimal nextX = currentX.subtract(currentY.divide(currentFirstDerivativeY, mc));
            if (currentX.subtract(nextX).abs().compareTo(epsilon) <= 0) {
                return nextX;
            }
            currentX = nextX;
            currentY = this.function.apply(currentX, mc);
            currentFirstDerivativeY = this.functionFirstDerivative.apply(currentX, mc);
        }
        return null;
    }
}

