/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.analysis.solver;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.BiFunction;

public class BisectionSolver {
    private BiFunction<BigDecimal, MathContext, BigDecimal> function;
    private int maxIterations = 100;
    private BigDecimal left;
    private BigDecimal right;

    public BisectionSolver(BiFunction<BigDecimal, MathContext, BigDecimal> function) {
        this.function = function;
    }

    public BisectionSolver withMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public BigDecimal solve(BigDecimal left, BigDecimal right, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 5, mathContext.getRoundingMode());
        BigDecimal result = this.solveInternal(left, right, mc);
        if (result != null && mathContext.getPrecision() != 0) {
            result = BigDecimalMath.roundAbsolutePrecision(result, mathContext);
        }
        return result;
    }

    private BigDecimal solveInternal(BigDecimal left, BigDecimal right, MathContext mc) {
        BigDecimal epsilon = BigDecimal.ONE.scaleByPowerOfTen(-mc.getPrecision() + 2);
        BigDecimal leftY = this.function.apply(left, mc);
        BigDecimal rightY = this.function.apply(right, mc);
        if (leftY == null || rightY == null || leftY.signum() == rightY.signum()) {
            return null;
        }
        if (leftY.signum() == 0) {
            return left;
        }
        if (rightY.signum() == 0) {
            return right;
        }
        int iteration = 0;
        while (iteration++ < this.maxIterations) {
            BigDecimal mid = left.add(right).multiply(BigDecimal.valueOf(0.5));
            BigDecimal midY = this.function.apply(mid, mc);
            if (midY == null) {
                return null;
            }
            if (leftY.signum() == midY.signum()) {
                left = mid;
                leftY = midY;
            } else {
                right = mid;
                rightY = midY;
            }
            if (midY.signum() != 0 && right.subtract(left).abs().compareTo(epsilon) > 0) continue;
            return mid;
        }
        return null;
    }
}

