/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.AsinCalculator;
import ch.obermuhlner.math.big.internal.CosCalculator;
import ch.obermuhlner.math.big.internal.CoshCalculator;
import ch.obermuhlner.math.big.internal.ExpCalculator;
import ch.obermuhlner.math.big.internal.SinCalculator;
import ch.obermuhlner.math.big.internal.SinhCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecimalMath {
    private static final BigDecimal TWO;
    private static final BigDecimal THREE;
    private static final BigDecimal MINUS_ONE;
    private static final BigDecimal DOUBLE_MAX_VALUE;
    private static final BigDecimal DOUBLE_MIN_VALUE;
    private static volatile BigDecimal log2Cache;
    private static final Object log2CacheLock;
    private static volatile BigDecimal log3Cache;
    private static final Object log3CacheLock;
    private static volatile BigDecimal log10Cache;
    private static final Object log10CacheLock;
    private static volatile BigDecimal piCache;
    private static final Object piCacheLock;
    private static volatile BigDecimal eCache;
    private static final Object eCacheLock;
    private static final BigDecimal ROUGHLY_TWO_PI;
    private static final int EXPECTED_INITIAL_PRECISION = 17;
    private static BigDecimal[] factorialCache;

    private BigDecimalMath() {
    }

    public static boolean isIntValue(BigDecimal value) {
        try {
            value.intValueExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public static boolean isDoubleValue(BigDecimal value) {
        if (value.compareTo(DOUBLE_MAX_VALUE) > 0) {
            return false;
        }
        if (value.signum() > 0 && value.compareTo(DOUBLE_MIN_VALUE) < 0) {
            return false;
        }
        if (value.compareTo(DOUBLE_MAX_VALUE.negate()) < 0) {
            return false;
        }
        return value.signum() >= 0 || value.compareTo(DOUBLE_MIN_VALUE.negate()) <= 0;
    }

    public static BigDecimal mantissa(BigDecimal value) {
        int exponent = BigDecimalMath.exponent(value);
        if (exponent == 0) {
            return value;
        }
        return value.movePointLeft(exponent);
    }

    public static int exponent(BigDecimal value) {
        return value.precision() - value.scale() - 1;
    }

    public static BigDecimal integralPart(BigDecimal value) {
        return value.setScale(0, 1);
    }

    public static BigDecimal fractionalPart(BigDecimal value) {
        return value.subtract(BigDecimalMath.integralPart(value));
    }

    public static BigDecimal factorial(int n) {
        if (n < 0) {
            throw new ArithmeticException("Illegal factorial(n) for n < 0: n = " + n);
        }
        if (n < factorialCache.length) {
            return factorialCache[n];
        }
        BigDecimal result = factorialCache[factorialCache.length - 1];
        for (int i = factorialCache.length; i <= n; ++i) {
            result = result.multiply(BigDecimal.valueOf(i));
        }
        return result;
    }

    public static BigDecimal bernoulli(int n, MathContext mathContext) {
        if (n < 0) {
            throw new ArithmeticException("Illegal bernoulli(n) for n < 0: n = " + n);
        }
        BigRational b = BigRational.bernoulli(n);
        return b.toBigDecimal(mathContext);
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y, MathContext mathContext) {
        if (x.signum() == 0) {
            switch (y.signum()) {
                case 0: {
                    return BigDecimal.ONE;
                }
                case 1: {
                    return BigDecimal.ZERO;
                }
            }
        }
        try {
            int intValue = y.intValueExact();
            return BigDecimalMath.pow(x, intValue, mathContext);
        }
        catch (ArithmeticException intValue) {
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            BigDecimal result = BigDecimalMath.exp(y.multiply(BigDecimalMath.log(x, mc), mc), mc);
            return result.round(mathContext);
        }
    }

    public static BigDecimal pow(BigDecimal x, int y, MathContext mathContext) {
        if (y < 0) {
            return BigDecimal.ONE.divide(BigDecimalMath.pow(x, -y, mathContext), mathContext);
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimal.ONE;
        while (y > 0) {
            if ((y & 1) == 1) {
                result = result.multiply(x, mc);
                --y;
            }
            if (y > 0) {
                x = x.multiply(x, mc);
            }
            y >>= 1;
        }
        return result.round(mathContext);
    }

    public static BigDecimal sqrt(BigDecimal x, MathContext mathContext) {
        BigDecimal last;
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal sqrt(x) for x < 0: x = " + x);
            }
        }
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal result = BigDecimalMath.isDoubleValue(x) ? BigDecimal.valueOf(Math.sqrt(x.doubleValue())) : x.divide(TWO, mathContext);
        if (result.multiply(result, mathContext).compareTo(x) == 0) {
            return result.round(mathContext);
        }
        int adaptivePrecision = 17;
        do {
            last = result;
            if ((adaptivePrecision *= 2) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            result = x.divide(result, mc).add(last, mc).divide(TWO, mc);
        } while (adaptivePrecision < maxPrecision || result.subtract(last).abs().compareTo(acceptableError) > 0);
        return result.round(mathContext);
    }

    public static BigDecimal root(BigDecimal x, BigDecimal n, MathContext mathContext) {
        BigDecimal step;
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal root(x) for x < 0: x = " + x);
            }
        }
        if (n.compareTo(BigDecimal.ONE) <= 0) {
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            return BigDecimalMath.pow(x, BigDecimal.ONE.divide(n, mc), mathContext);
        }
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal nMinus1 = n.subtract(BigDecimal.ONE);
        BigDecimal result = x.divide(TWO, MathContext.DECIMAL32);
        int adaptivePrecision = 2;
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            step = x.divide(BigDecimalMath.pow(result, nMinus1, mc), mc).subtract(result, mc).divide(n, mc);
            result = result.add(step, mc);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result.round(mathContext);
    }

    public static BigDecimal log(BigDecimal x, MathContext mathContext) {
        BigDecimal result;
        if (x.signum() <= 0) {
            throw new ArithmeticException("Illegal log(x) for x <= 0: x = " + x);
        }
        if (x.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        switch (x.compareTo(BigDecimal.TEN)) {
            case 0: {
                result = BigDecimalMath.logTen(mathContext);
                break;
            }
            case 1: {
                result = BigDecimalMath.logUsingExponent(x, mathContext);
                break;
            }
            default: {
                result = BigDecimalMath.logUsingTwoThree(x, mathContext);
            }
        }
        return result.round(mathContext);
    }

    public static BigDecimal log2(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x, mc).divide(BigDecimalMath.logTwo(mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal log10(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 2, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x, mc).divide(BigDecimalMath.logTen(mc), mc);
        return result.round(mathContext);
    }

    private static BigDecimal logUsingNewton(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        int adaptivePrecision;
        BigDecimal result;
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        if (BigDecimalMath.isDoubleValue(x)) {
            result = BigDecimal.valueOf(Math.log(x.doubleValue()));
            adaptivePrecision = 17;
        } else {
            result = x.divide(TWO, mathContext);
            adaptivePrecision = 1;
        }
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            BigDecimal expY = BigDecimalMath.exp(result, mc);
            step = TWO.multiply(x.subtract(expY, mc), mc).divide(x.add(expY, mc), mc);
            result = result.add(step);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result;
    }

    private static BigDecimal logUsingTwoThree(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int factorOfTwo = 0;
        int powerOfTwo = 1;
        int factorOfThree = 0;
        int powerOfThree = 1;
        double value = x.doubleValue();
        if (!(value < 0.01)) {
            if (value < 0.1) {
                while (value < 0.6) {
                    value *= 2.0;
                    --factorOfTwo;
                    powerOfTwo *= 2;
                }
            } else if (value < 0.115) {
                factorOfThree = -2;
                powerOfThree = 9;
            } else if (value < 0.14) {
                factorOfTwo = -3;
                powerOfTwo = 8;
            } else if (value < 0.2) {
                factorOfTwo = -1;
                powerOfTwo = 2;
                factorOfThree = -1;
                powerOfThree = 3;
            } else if (value < 0.3) {
                factorOfTwo = -2;
                powerOfTwo = 4;
            } else if (value < 0.42) {
                factorOfThree = -1;
                powerOfThree = 3;
            } else if (value < 0.7) {
                factorOfTwo = -1;
                powerOfTwo = 2;
            } else if (!(value < 1.4)) {
                if (value < 2.5) {
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                } else if (value < 3.5) {
                    factorOfThree = 1;
                    powerOfThree = 3;
                } else if (value < 5.0) {
                    factorOfTwo = 2;
                    powerOfTwo = 4;
                } else if (value < 7.0) {
                    factorOfThree = 1;
                    powerOfThree = 3;
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                } else if (value < 8.5) {
                    factorOfTwo = 3;
                    powerOfTwo = 8;
                } else if (value < 10.0) {
                    factorOfThree = 2;
                    powerOfThree = 9;
                } else {
                    while (value > 1.4) {
                        value /= 2.0;
                        ++factorOfTwo;
                        powerOfTwo *= 2;
                    }
                }
            }
        }
        BigDecimal correctedX = x;
        BigDecimal result = BigDecimal.ZERO;
        if (factorOfTwo > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.add(BigDecimalMath.logTwo(mc).multiply(BigDecimal.valueOf(factorOfTwo), mc), mc);
        } else if (factorOfTwo < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.subtract(BigDecimalMath.logTwo(mc).multiply(BigDecimal.valueOf(-factorOfTwo), mc), mc);
        }
        if (factorOfThree > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfThree), mc);
            result = result.add(BigDecimalMath.logThree(mc).multiply(BigDecimal.valueOf(factorOfThree), mc), mc);
        } else if (factorOfThree < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfThree), mc);
            result = result.subtract(BigDecimalMath.logThree(mc).multiply(BigDecimal.valueOf(-factorOfThree), mc), mc);
        }
        result = result.add(BigDecimalMath.logUsingNewton(correctedX, mc));
        return result;
    }

    private static BigDecimal logUsingExponent(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int exponent = BigDecimalMath.exponent(x);
        BigDecimal mantissa = BigDecimalMath.mantissa(x);
        BigDecimal result = BigDecimalMath.logUsingTwoThree(mantissa, mc);
        if (exponent != 0) {
            result = result.add(BigDecimal.valueOf(exponent).multiply(BigDecimalMath.logTen(mc), mc), mc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal pi(MathContext mathContext) {
        BigDecimal result = null;
        Object object = piCacheLock;
        synchronized (object) {
            if (piCache == null || mathContext.getPrecision() > piCache.precision()) {
                piCache = BigDecimalMath.piChudnovski(mathContext);
                return piCache;
            }
            result = piCache;
        }
        return result.round(mathContext);
    }

    private static BigDecimal piChudnovski(MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal value24 = BigDecimal.valueOf(24L);
        BigDecimal value640320 = BigDecimal.valueOf(640320L);
        BigDecimal value13591409 = BigDecimal.valueOf(13591409L);
        BigDecimal value545140134 = BigDecimal.valueOf(545140134L);
        BigDecimal valueDivisor = value640320.pow(3).divide(value24, mc);
        BigDecimal sumA = BigDecimal.ONE;
        BigDecimal sumB = BigDecimal.ZERO;
        BigDecimal a = BigDecimal.ONE;
        long dividendTerm1 = 5L;
        long dividendTerm2 = -1L;
        long dividendTerm3 = -1L;
        BigDecimal kPower3 = BigDecimal.ZERO;
        long iterationCount = (mc.getPrecision() + 13) / 14;
        for (long k = 1L; k <= iterationCount; ++k) {
            BigDecimal valueK = BigDecimal.valueOf(k);
            BigDecimal dividend = BigDecimal.valueOf(dividendTerm1 += -6L).multiply(BigDecimal.valueOf(dividendTerm2 += 2L)).multiply(BigDecimal.valueOf(dividendTerm3 += 6L));
            kPower3 = valueK.pow(3);
            BigDecimal divisor = kPower3.multiply(valueDivisor, mc);
            a = a.multiply(dividend).divide(divisor, mc);
            BigDecimal b = valueK.multiply(a, mc);
            sumA = sumA.add(a);
            sumB = sumB.add(b);
        }
        BigDecimal value426880 = BigDecimal.valueOf(426880L);
        BigDecimal value10005 = BigDecimal.valueOf(10005L);
        BigDecimal factor = value426880.multiply(BigDecimalMath.sqrt(value10005, mc));
        BigDecimal pi = factor.divide(value13591409.multiply(sumA, mc).add(value545140134.multiply(sumB, mc)), mc);
        return pi.round(mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal e(MathContext mathContext) {
        BigDecimal result = null;
        Object object = eCacheLock;
        synchronized (object) {
            if (eCache == null || mathContext.getPrecision() > eCache.precision()) {
                eCache = BigDecimalMath.exp(BigDecimal.ONE, mathContext);
                return eCache;
            }
            result = eCache;
        }
        return result.round(mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTen(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log10CacheLock;
        synchronized (object) {
            if (log10Cache == null || mathContext.getPrecision() > log10Cache.precision()) {
                log10Cache = BigDecimalMath.logUsingNewton(BigDecimal.TEN, mathContext);
                return log10Cache;
            }
            result = log10Cache;
        }
        return result.round(mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logTwo(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log2CacheLock;
        synchronized (object) {
            if (log2Cache == null || mathContext.getPrecision() > log2Cache.precision()) {
                log2Cache = BigDecimalMath.logUsingNewton(TWO, mathContext);
                return log2Cache;
            }
            result = log2Cache;
        }
        return result.round(mathContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigDecimal logThree(MathContext mathContext) {
        BigDecimal result = null;
        Object object = log3CacheLock;
        synchronized (object) {
            if (log3Cache == null || mathContext.getPrecision() > log3Cache.precision()) {
                log3Cache = BigDecimalMath.logUsingNewton(THREE, mathContext);
                return log3Cache;
            }
            result = log3Cache;
        }
        return result.round(mathContext);
    }

    public static BigDecimal exp(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimalMath.expIntegralFractional(x, mathContext);
    }

    private static BigDecimal expIntegralFractional(BigDecimal x, MathContext mathContext) {
        BigDecimal integralPart = BigDecimalMath.integralPart(x);
        if (integralPart.signum() == 0) {
            return BigDecimalMath.expTaylor(x, mathContext);
        }
        BigDecimal fractionalPart = x.subtract(integralPart);
        MathContext mc = new MathContext(mathContext.getPrecision() + 9, mathContext.getRoundingMode());
        BigDecimal z = BigDecimal.ONE.add(fractionalPart.divide(integralPart, mc));
        BigDecimal t = BigDecimalMath.expTaylor(z, mc);
        BigDecimal result = BigDecimalMath.pow(t, integralPart.intValue(), mc);
        return result.round(mathContext);
    }

    private static BigDecimal expTaylor(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        x = x.divide(BigDecimal.valueOf(256L), mc);
        BigDecimal result = ExpCalculator.INSTANCE.calculate(x, mc);
        result = BigDecimalMath.pow(result, 256, mc);
        return result.round(mathContext);
    }

    public static BigDecimal sin(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.abs().compareTo(ROUGHLY_TWO_PI) > 0) {
            BigDecimal twoPi = TWO.multiply(BigDecimalMath.pi(mc), mc);
            x = x.remainder(twoPi, mc);
        }
        BigDecimal result = SinCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal asin(BigDecimal x, MathContext mathContext) {
        if (x.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal asin(x) for x > 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) < 0) {
            throw new ArithmeticException("Illegal asin(x) for x < -1: x = " + x);
        }
        if (x.signum() == -1) {
            return BigDecimalMath.asin(x.negate(), mathContext).negate();
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.compareTo(BigDecimal.valueOf(0.707107)) >= 0) {
            BigDecimal xTransformed = BigDecimalMath.sqrt(BigDecimal.ONE.subtract(x.multiply(x, mc), mc), mc);
            return BigDecimalMath.acos(xTransformed, mathContext);
        }
        BigDecimal result = AsinCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal cos(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.abs().compareTo(ROUGHLY_TWO_PI) > 0) {
            BigDecimal twoPi = TWO.multiply(BigDecimalMath.pi(mc), mc);
            x = x.remainder(twoPi, mc);
        }
        BigDecimal result = CosCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal acos(BigDecimal x, MathContext mathContext) {
        if (x.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal acos(x) for x > 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) < 0) {
            throw new ArithmeticException("Illegal acos(x) for x < -1: x = " + x);
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.pi(mc).divide(TWO, mc).subtract(BigDecimalMath.asin(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal tan(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            return BigDecimal.ZERO;
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigDecimalMath.sin(x, mc).divide(BigDecimalMath.cos(x, mc), mc).round(mathContext);
    }

    public static BigDecimal atan(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        x = x.divide(BigDecimalMath.sqrt(BigDecimal.ONE.add(x.multiply(x, mc), mc), mc), mc);
        BigDecimal result = BigDecimalMath.asin(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal cot(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            throw new ArithmeticException("Illegal cot(x) for x = 0");
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.cos(x, mc).divide(BigDecimalMath.sin(x, mc), mc).round(mathContext);
        return result.round(mathContext);
    }

    public static BigDecimal acot(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.pi(mc).divide(TWO, mc).subtract(BigDecimalMath.atan(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal sinh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = SinhCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal cosh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = CoshCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal tanh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.sinh(x, mc).divide(BigDecimalMath.cosh(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal coth(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.cosh(x, mc).divide(BigDecimalMath.sinh(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal asinh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimalMath.sqrt(x.multiply(x, mc).add(BigDecimal.ONE, mc), mc), mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal acosh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimalMath.sqrt(x.multiply(x, mc).subtract(BigDecimal.ONE, mc), mc), mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal atanh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(BigDecimal.ONE.add(x, mc).divide(BigDecimal.ONE.subtract(x, mc), mc), mc).divide(TWO, mc);
        return result.round(mathContext);
    }

    public static BigDecimal acoth(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimal.ONE, mc).divide(x.subtract(BigDecimal.ONE, mc), mc), mc).divide(TWO, mc);
        return result.round(mathContext);
    }

    static {
        BigDecimal result;
        TWO = BigDecimal.valueOf(2L);
        THREE = BigDecimal.valueOf(3L);
        MINUS_ONE = BigDecimal.valueOf(-1L);
        DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
        DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
        log2CacheLock = new Object();
        log3CacheLock = new Object();
        log10CacheLock = new Object();
        piCacheLock = new Object();
        eCacheLock = new Object();
        ROUGHLY_TWO_PI = new BigDecimal("3.141592653589793").multiply(TWO);
        factorialCache = new BigDecimal[100];
        BigDecimalMath.factorialCache[0] = result = BigDecimal.ONE;
        for (int i = 1; i < factorialCache.length; ++i) {
            BigDecimalMath.factorialCache[i] = result = result.multiply(BigDecimal.valueOf(i));
        }
    }
}

