/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.AsinCalculator;
import ch.obermuhlner.math.big.internal.CosCalculator;
import ch.obermuhlner.math.big.internal.CoshCalculator;
import ch.obermuhlner.math.big.internal.ExpCalculator;
import ch.obermuhlner.math.big.internal.SinCalculator;
import ch.obermuhlner.math.big.internal.SinhCalculator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class BigDecimalMath {
    public static Context DECIMAL128;
    public static Context DECIMAL64;
    public static Context DECIMAL32;
    public static Context UNLIMITED;
    private static final BigDecimal TWO;
    private static final BigDecimal THREE;
    private static final BigDecimal MINUS_ONE;
    private static final BigDecimal LOG_TWO;
    private static final BigDecimal LOG_THREE;
    private static final BigDecimal LOG_TEN;
    private static final BigDecimal PI;
    private static final BigDecimal ROUGHLY_TWO_PI;
    private static final BigDecimal MAX_INT;
    private static final int EXPECTED_INITIAL_PRECISION = 17;
    private static BigDecimal[] factorialCache;

    private BigDecimalMath() {
    }

    public static boolean isIntValue(BigDecimal value) {
        try {
            value.intValueExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public static BigDecimal mantissa(BigDecimal value) {
        int exponent = BigDecimalMath.exponent(value);
        if (exponent == 0) {
            return value;
        }
        return value.movePointLeft(exponent);
    }

    public static int exponent(BigDecimal value) {
        return value.precision() - value.scale() - 1;
    }

    public static BigDecimal integralPart(BigDecimal value) {
        return value.setScale(0, 1);
    }

    public static BigDecimal fractionalPart(BigDecimal value) {
        return value.subtract(BigDecimalMath.integralPart(value));
    }

    public static BigDecimal factorial(int n) {
        if (n < 0) {
            throw new ArithmeticException("Illegal factorial(n) for n < 0: n = " + n);
        }
        if (n < factorialCache.length) {
            return factorialCache[n];
        }
        BigDecimal result = factorialCache[factorialCache.length - 1];
        for (int i = factorialCache.length; i <= n; ++i) {
            result = result.multiply(BigDecimal.valueOf(i));
        }
        return result;
    }

    public static BigDecimal bernoulli(int n, MathContext mathContext) {
        if (n < 0) {
            throw new ArithmeticException("Illegal bernoulli(n) for n < 0: n = " + n);
        }
        BigRational b = BigRational.bernoulli(n);
        return b.toBigDecimal(mathContext);
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y, MathContext mathContext) {
        if (x.signum() == 0) {
            switch (y.signum()) {
                case 0: {
                    return BigDecimal.ONE;
                }
                case 1: {
                    return BigDecimal.ZERO;
                }
            }
        }
        try {
            int intValue = y.intValueExact();
            return BigDecimalMath.pow(x, intValue, mathContext);
        }
        catch (ArithmeticException intValue) {
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            BigDecimal result = BigDecimalMath.exp(y.multiply(BigDecimalMath.log(x, mc), mc), mc);
            return result.round(mathContext);
        }
    }

    public static BigDecimal pow(BigDecimal x, int y, MathContext mathContext) {
        if (y < 0) {
            return BigDecimal.ONE.divide(BigDecimalMath.pow(x, -y, mathContext), mathContext);
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimal.ONE;
        while (y > 0) {
            if ((y & 1) == 1) {
                result = result.multiply(x, mc);
                --y;
            }
            if (y > 0) {
                x = x.multiply(x, mc);
            }
            y >>= 1;
        }
        return result.round(mathContext);
    }

    public static BigDecimal sqrt(BigDecimal x, MathContext mathContext) {
        BigDecimal last;
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal sqrt(x) for x < 0: x = " + x);
            }
        }
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal result = BigDecimal.valueOf(Math.sqrt(x.doubleValue()));
        int adaptivePrecision = 17;
        do {
            last = result;
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            result = x.divide(result, mc).add(last, mc).divide(TWO, mc);
        } while (adaptivePrecision < maxPrecision || result.subtract(last).abs().compareTo(acceptableError) > 0);
        return result.round(mathContext);
    }

    public static BigDecimal root(BigDecimal x, BigDecimal n, MathContext mathContext) {
        BigDecimal step;
        switch (x.signum()) {
            case 0: {
                return BigDecimal.ZERO;
            }
            case -1: {
                throw new ArithmeticException("Illegal root(x) for x < 0: x = " + x);
            }
        }
        if (n.compareTo(BigDecimal.ONE) <= 0) {
            MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
            return BigDecimalMath.pow(x, BigDecimal.ONE.divide(n, mc), mathContext);
        }
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal nMinus1 = n.subtract(BigDecimal.ONE);
        BigDecimal result = x.divide(TWO, MathContext.DECIMAL32);
        int adaptivePrecision = 2;
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            step = x.divide(BigDecimalMath.pow(result, nMinus1, mc), mc).subtract(result, mc).divide(n, mc);
            result = result.add(step, mc);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result.round(mathContext);
    }

    public static BigDecimal log(BigDecimal x, MathContext mathContext) {
        BigDecimal result;
        if (x.signum() <= 0) {
            throw new ArithmeticException("Illegal log(x) for x <= 0: x = " + x);
        }
        if (x.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        switch (x.compareTo(BigDecimal.TEN)) {
            case 0: {
                result = BigDecimalMath.logTen(mathContext);
                break;
            }
            case 1: {
                result = BigDecimalMath.logUsingExponent(x, mathContext);
                break;
            }
            default: {
                result = BigDecimalMath.logUsingTwoThree(x, mathContext);
            }
        }
        return result.round(mathContext);
    }

    public static BigDecimal log2(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x, mc).divide(BigDecimalMath.logTwo(mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal log10(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 2, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x, mc).divide(BigDecimalMath.logTen(mc), mc);
        return result.round(mathContext);
    }

    private static BigDecimal logUsingNewton(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        int maxPrecision = mathContext.getPrecision() + 4;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigDecimal result = BigDecimal.valueOf(Math.log(x.doubleValue()));
        int adaptivePrecision = 17;
        do {
            if ((adaptivePrecision *= 3) > maxPrecision) {
                adaptivePrecision = maxPrecision;
            }
            MathContext mc = new MathContext(adaptivePrecision, mathContext.getRoundingMode());
            BigDecimal expY = BigDecimalMath.exp(result, mc);
            step = TWO.multiply(x.subtract(expY, mc), mc).divide(x.add(expY, mc), mc);
            result = result.add(step);
        } while (adaptivePrecision < maxPrecision || step.abs().compareTo(acceptableError) > 0);
        return result;
    }

    private static BigDecimal logUsingTwoThree(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int factorOfTwo = 0;
        int powerOfTwo = 1;
        int factorOfThree = 0;
        int powerOfThree = 1;
        double value = x.doubleValue();
        if (!(value < 0.01)) {
            if (value < 0.1) {
                while (value < 0.6) {
                    value *= 2.0;
                    --factorOfTwo;
                    powerOfTwo *= 2;
                }
            } else if (value < 0.115) {
                factorOfThree = -2;
                powerOfThree = 9;
            } else if (value < 0.14) {
                factorOfTwo = -3;
                powerOfTwo = 8;
            } else if (value < 0.2) {
                factorOfTwo = -1;
                powerOfTwo = 2;
                factorOfThree = -1;
                powerOfThree = 3;
            } else if (value < 0.3) {
                factorOfTwo = -2;
                powerOfTwo = 4;
            } else if (value < 0.42) {
                factorOfThree = -1;
                powerOfThree = 3;
            } else if (value < 0.7) {
                factorOfTwo = -1;
                powerOfTwo = 2;
            } else if (!(value < 1.4)) {
                if (value < 2.5) {
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                } else if (value < 3.5) {
                    factorOfThree = 1;
                    powerOfThree = 3;
                } else if (value < 5.0) {
                    factorOfTwo = 2;
                    powerOfTwo = 4;
                } else if (value < 7.0) {
                    factorOfThree = 1;
                    powerOfThree = 3;
                    factorOfTwo = 1;
                    powerOfTwo = 2;
                } else if (value < 8.5) {
                    factorOfTwo = 3;
                    powerOfTwo = 8;
                } else if (value < 10.0) {
                    factorOfThree = 2;
                    powerOfThree = 9;
                } else {
                    while (value > 1.4) {
                        value /= 2.0;
                        ++factorOfTwo;
                        powerOfTwo *= 2;
                    }
                }
            }
        }
        BigDecimal correctedX = x;
        BigDecimal result = BigDecimal.ZERO;
        if (factorOfTwo > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.add(BigDecimalMath.logTwo(mc).multiply(BigDecimal.valueOf(factorOfTwo), mc), mc);
        } else if (factorOfTwo < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfTwo), mc);
            result = result.subtract(BigDecimalMath.logTwo(mc).multiply(BigDecimal.valueOf(-factorOfTwo), mc), mc);
        }
        if (factorOfThree > 0) {
            correctedX = correctedX.divide(BigDecimal.valueOf(powerOfThree), mc);
            result = result.add(BigDecimalMath.logThree(mc).multiply(BigDecimal.valueOf(factorOfThree), mc), mc);
        } else if (factorOfThree < 0) {
            correctedX = correctedX.multiply(BigDecimal.valueOf(powerOfThree), mc);
            result = result.subtract(BigDecimalMath.logThree(mc).multiply(BigDecimal.valueOf(-factorOfThree), mc), mc);
        }
        result = result.add(BigDecimalMath.logUsingNewton(correctedX, mc));
        return result;
    }

    private static BigDecimal logUsingExponent(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        int exponent = BigDecimalMath.exponent(x);
        BigDecimal mantissa = BigDecimalMath.mantissa(x);
        BigDecimal result = BigDecimalMath.logUsingTwoThree(mantissa, mc);
        if (exponent != 0) {
            result = result.add(BigDecimal.valueOf(exponent).multiply(BigDecimalMath.logTen(mc), mc), mc);
        }
        return result;
    }

    public static BigDecimal pi(MathContext mathContext) {
        if (mathContext.getPrecision() < PI.precision()) {
            return PI.round(mathContext);
        }
        return BigDecimalMath.piChudnovski(mathContext);
    }

    private static BigDecimal piChudnovski(MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        BigDecimal value24 = BigDecimal.valueOf(24L);
        BigDecimal value640320 = BigDecimal.valueOf(640320L);
        BigDecimal value13591409 = BigDecimal.valueOf(13591409L);
        BigDecimal value545140134 = BigDecimal.valueOf(545140134L);
        BigDecimal valueDivisor = value640320.pow(3).divide(value24, mc);
        BigDecimal sumA = BigDecimal.ONE;
        BigDecimal sumB = BigDecimal.ZERO;
        BigDecimal a = BigDecimal.ONE;
        long dividendTerm1 = 5L;
        long dividendTerm2 = -1L;
        long dividendTerm3 = -1L;
        BigDecimal kPower3 = BigDecimal.ZERO;
        long iterationCount = (mc.getPrecision() + 13) / 14;
        for (long k = 1L; k <= iterationCount; ++k) {
            BigDecimal valueK = BigDecimal.valueOf(k);
            BigDecimal dividend = BigDecimal.valueOf(dividendTerm1 += -6L).multiply(BigDecimal.valueOf(dividendTerm2 += 2L)).multiply(BigDecimal.valueOf(dividendTerm3 += 6L));
            kPower3 = valueK.pow(3);
            BigDecimal divisor = kPower3.multiply(valueDivisor, mc);
            a = a.multiply(dividend).divide(divisor, mc);
            BigDecimal b = valueK.multiply(a, mc);
            sumA = sumA.add(a);
            sumB = sumB.add(b);
        }
        BigDecimal value426880 = BigDecimal.valueOf(426880L);
        BigDecimal value10005 = BigDecimal.valueOf(10005L);
        BigDecimal factor = value426880.multiply(BigDecimalMath.sqrt(value10005, mc));
        BigDecimal pi = factor.divide(value13591409.multiply(sumA, mc).add(value545140134.multiply(sumB, mc)), mc);
        return pi.round(mathContext);
    }

    public static BigDecimal e(MathContext mathContext) {
        return BigDecimalMath.exp(BigDecimal.ONE, mathContext);
    }

    private static BigDecimal logTen(MathContext mathContext) {
        if (mathContext.getPrecision() < LOG_TEN.precision()) {
            return LOG_TEN;
        }
        return BigDecimalMath.logUsingNewton(BigDecimal.TEN, mathContext);
    }

    private static BigDecimal logTwo(MathContext mathContext) {
        if (mathContext.getPrecision() < LOG_TWO.precision()) {
            return LOG_TWO;
        }
        return BigDecimalMath.logUsingNewton(TWO, mathContext);
    }

    private static BigDecimal logThree(MathContext mathContext) {
        if (mathContext.getPrecision() < LOG_THREE.precision()) {
            return LOG_THREE;
        }
        return BigDecimalMath.logUsingNewton(THREE, mathContext);
    }

    public static BigDecimal exp(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimalMath.expIntegralFractional(x, mathContext);
    }

    private static BigDecimal expIntegralFractional(BigDecimal x, MathContext mathContext) {
        BigDecimal integralPart = BigDecimalMath.integralPart(x);
        if (integralPart.signum() == 0) {
            return BigDecimalMath.expTaylor(x, mathContext);
        }
        BigDecimal fractionalPart = x.subtract(integralPart);
        MathContext mc = new MathContext(mathContext.getPrecision() + 5, mathContext.getRoundingMode());
        BigDecimal z = BigDecimal.ONE.add(fractionalPart.divide(integralPart, mc));
        BigDecimal t = BigDecimalMath.expTaylor(z, mc);
        BigDecimal result = BigDecimal.ONE;
        while (integralPart.compareTo(MAX_INT) >= 0) {
            result = result.multiply(BigDecimalMath.pow(t, Integer.MAX_VALUE, mc), mc);
            integralPart = integralPart.subtract(MAX_INT);
        }
        result = result.multiply(BigDecimalMath.pow(t, integralPart.intValue(), mc));
        return result.round(mathContext);
    }

    private static BigDecimal expTaylor(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        x = x.divide(BigDecimal.valueOf(256L), mc);
        BigDecimal result = ExpCalculator.INSTANCE.calculate(x, mc);
        result = BigDecimalMath.pow(result, 256, mc);
        return result.round(mathContext);
    }

    public static BigDecimal sin(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.abs().compareTo(ROUGHLY_TWO_PI) > 0) {
            BigDecimal twoPi = TWO.multiply(BigDecimalMath.pi(mc), mc);
            x = x.remainder(twoPi, mc);
        }
        BigDecimal result = SinCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal asin(BigDecimal x, MathContext mathContext) {
        if (x.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal asin(x) for x > 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) < 0) {
            throw new ArithmeticException("Illegal asin(x) for x < -1: x = " + x);
        }
        if (x.signum() == -1) {
            return BigDecimalMath.asin(x.negate(), mathContext).negate();
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.compareTo(BigDecimal.valueOf(0.707107)) >= 0) {
            BigDecimal xTransformed = BigDecimalMath.sqrt(BigDecimal.ONE.subtract(x.multiply(x, mc), mc), mc);
            return BigDecimalMath.acos(xTransformed, mathContext);
        }
        BigDecimal result = AsinCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal cos(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        if (x.abs().compareTo(ROUGHLY_TWO_PI) > 0) {
            BigDecimal twoPi = TWO.multiply(BigDecimalMath.pi(mc), mc);
            x = x.remainder(twoPi, mc);
        }
        BigDecimal result = CosCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal acos(BigDecimal x, MathContext mathContext) {
        if (x.compareTo(BigDecimal.ONE) > 0) {
            throw new ArithmeticException("Illegal acos(x) for x > 1: x = " + x);
        }
        if (x.compareTo(MINUS_ONE) < 0) {
            throw new ArithmeticException("Illegal acos(x) for x < -1: x = " + x);
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.pi(mc).divide(TWO, mc).subtract(BigDecimalMath.asin(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal tan(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            return BigDecimal.ZERO;
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigDecimalMath.sin(x, mc).divide(BigDecimalMath.cos(x, mc), mc).round(mathContext);
    }

    public static BigDecimal atan(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        x = x.divide(BigDecimalMath.sqrt(BigDecimal.ONE.add(x.multiply(x, mc), mc), mc), mc);
        BigDecimal result = BigDecimalMath.asin(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal cot(BigDecimal x, MathContext mathContext) {
        if (x.signum() == 0) {
            throw new ArithmeticException("Illegal cot(x) for x = 0");
        }
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.cos(x, mc).divide(BigDecimalMath.sin(x, mc), mc).round(mathContext);
        return result.round(mathContext);
    }

    public static BigDecimal acot(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.pi(mc).divide(TWO, mc).subtract(BigDecimalMath.atan(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal sinh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = SinhCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal cosh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal result = CoshCalculator.INSTANCE.calculate(x, mc);
        return result.round(mathContext);
    }

    public static BigDecimal tanh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.sinh(x, mc).divide(BigDecimalMath.cosh(x, mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal asinh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimalMath.sqrt(x.multiply(x, mc).add(BigDecimal.ONE, mc), mc), mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal acosh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimalMath.sqrt(x.multiply(x, mc).subtract(BigDecimal.ONE, mc), mc), mc), mc);
        return result.round(mathContext);
    }

    public static BigDecimal atanh(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(BigDecimal.ONE.add(x, mc).divide(BigDecimal.ONE.subtract(x, mc), mc), mc).divide(TWO, mc);
        return result.round(mathContext);
    }

    public static BigDecimal acoth(BigDecimal x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 6, mathContext.getRoundingMode());
        BigDecimal result = BigDecimalMath.log(x.add(BigDecimal.ONE, mc).divide(x.subtract(BigDecimal.ONE, mc), mc), mc).divide(TWO, mc);
        return result.round(mathContext);
    }

    static {
        BigDecimal result;
        DECIMAL128 = new Context(MathContext.DECIMAL128);
        DECIMAL64 = new Context(MathContext.DECIMAL64);
        DECIMAL32 = new Context(MathContext.DECIMAL32);
        UNLIMITED = new Context(MathContext.UNLIMITED);
        TWO = BigDecimal.valueOf(2L);
        THREE = BigDecimal.valueOf(3L);
        MINUS_ONE = BigDecimal.valueOf(-1L);
        LOG_TWO = new BigDecimal("0.69314718055994530941723212145817656807550013436025525412068000949339362196969471560586332699641868754200148102057068573368552023575813055703267075163507596193072757082837143519030703862389167347112335011536449795523912047517268157493206515552473413952588295045300709532636664265410423915781495204374043038550080194417064167151864471283996817178454695702627163106454615025720740248163777338963855069526066834113727387372292895649354702576265209885969320196505855476470330679365443254763274495125040606943814710468994650622016772042452452961268794654619316517468139267250410380254625965686914419287160829380317271436778265487756648508567407764845146443994046142260319309673540257444607030809608504748663852313818167675143866747664789088143714198549423151997354880375165861275352916610007105355824987941472950929311389715599820565439287170007218085761025236889213244971389320378439353088774825970171559107088236836275898425891853530243634214367061189236789192372314672321720534016492568727477823445353476481149418642386776774406069562657379600867076257199184734022651462837904883062033061144630073719489");
        LOG_THREE = new BigDecimal("1.0986122886681096913952452369225257046474905578227494517346943336374942932186089668736157548137320887879700290659578657423680042259305198210528018707672774106031627691833813671793736988443609599037425703167959115211455919177506713470549401667755802222031702529468975606901065215056428681380363173732985777823669916547921318181490200301038236301222486527481982259910974524908964580534670088459650857484441190188570876474948670796130858294116021661211840014098255143919487688936798494302255731535329685345295251459213876494685932562794416556941578272310355168866102118469890439943063138255285736466882824988136822800634143910786893251456437510204451627561934973982116941585740535361758900975122233797736969687754354795135712982177017581242122351405810163272465588937249564919185242960796684234647069377237252655082032078333928055892853146873095132606458309184397496822230325765467533311823019649275257599132217851353390237482964339502546074245824934666866121881436526565429542767610505477795422933973323401173743193974579847018559548494059478353943841010602930762292228131207489306344534025277732685627");
        LOG_TEN = new BigDecimal("2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058498078280597511938544450099781311469159346662410718466923101075984383191913");
        PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632788659361533818279682303019520353018529689957736225994138912497217752834791315");
        ROUGHLY_TWO_PI = new BigDecimal("3.141592653589793").multiply(TWO);
        MAX_INT = BigDecimal.valueOf(Integer.MAX_VALUE);
        factorialCache = new BigDecimal[100];
        BigDecimalMath.factorialCache[0] = result = BigDecimal.ONE;
        for (int i = 1; i < factorialCache.length; ++i) {
            BigDecimalMath.factorialCache[i] = result = result.multiply(BigDecimal.valueOf(i));
        }
    }

    public static class Context {
        private MathContext mathContext;

        public Context(MathContext mathContext) {
            this.mathContext = mathContext;
        }

        public BigDecimal valueOf(int value) {
            return new BigDecimal(value, this.mathContext);
        }

        public BigDecimal valueOf(long value) {
            return new BigDecimal(value, this.mathContext);
        }

        public BigDecimal valueOf(double value) {
            return BigDecimal.valueOf(value).round(this.mathContext);
        }

        public BigDecimal valueOf(BigInteger value) {
            return new BigDecimal(value, this.mathContext);
        }

        public BigDecimal valueOf(String value) {
            return new BigDecimal(value, this.mathContext);
        }

        public BigDecimal add(BigDecimal x, BigDecimal y) {
            return x.add(y, this.mathContext);
        }

        public BigDecimal subtract(BigDecimal x, BigDecimal y) {
            return x.subtract(y, this.mathContext);
        }

        public BigDecimal multiply(BigDecimal x, BigDecimal y) {
            return x.multiply(y, this.mathContext);
        }

        public BigDecimal divide(BigDecimal x, BigDecimal y) {
            return x.divide(y, this.mathContext);
        }

        public BigDecimal divideToIntegralValue(BigDecimal x, BigDecimal y) {
            return x.divideToIntegralValue(y, this.mathContext);
        }

        public BigDecimal remainder(BigDecimal x, BigDecimal y) {
            return x.remainder(y, this.mathContext);
        }

        public BigDecimal[] divideAndRemainder(BigDecimal x, BigDecimal y) {
            return x.divideAndRemainder(y, this.mathContext);
        }

        public BigDecimal abs(BigDecimal x) {
            return x.abs(this.mathContext);
        }

        public BigDecimal negate(BigDecimal x) {
            return x.negate(this.mathContext);
        }

        public BigDecimal log(BigDecimal x) {
            return BigDecimalMath.log(x, this.mathContext);
        }

        public BigDecimal log2(BigDecimal x) {
            return BigDecimalMath.log2(x, this.mathContext);
        }

        public BigDecimal log10(BigDecimal x) {
            return BigDecimalMath.log10(x, this.mathContext);
        }

        public BigDecimal pow(BigDecimal x, BigDecimal y) {
            return BigDecimalMath.pow(x, y, this.mathContext);
        }

        public BigDecimal pow(BigDecimal x, int y) {
            return BigDecimalMath.pow(x, y, this.mathContext);
        }

        public BigDecimal exp(BigDecimal x) {
            return BigDecimalMath.exp(x, this.mathContext);
        }

        public BigDecimal sqrt(BigDecimal x) {
            return BigDecimalMath.sqrt(x, this.mathContext);
        }

        public BigDecimal root(BigDecimal x, BigDecimal n) {
            return BigDecimalMath.root(x, n, this.mathContext);
        }

        public BigDecimal sin(BigDecimal x) {
            return BigDecimalMath.sin(x, this.mathContext);
        }

        public BigDecimal cos(BigDecimal x) {
            return BigDecimalMath.cos(x, this.mathContext);
        }

        public BigDecimal tan(BigDecimal x) {
            return BigDecimalMath.tan(x, this.mathContext);
        }

        public BigDecimal cot(BigDecimal x) {
            return BigDecimalMath.cot(x, this.mathContext);
        }

        public BigDecimal asin(BigDecimal x) {
            return BigDecimalMath.asin(x, this.mathContext);
        }

        public BigDecimal acos(BigDecimal x) {
            return BigDecimalMath.acos(x, this.mathContext);
        }

        public BigDecimal atan(BigDecimal x) {
            return BigDecimalMath.atan(x, this.mathContext);
        }

        public BigDecimal acot(BigDecimal x) {
            return BigDecimalMath.acot(x, this.mathContext);
        }

        public BigDecimal sinh(BigDecimal x) {
            return BigDecimalMath.sinh(x, this.mathContext);
        }

        public BigDecimal cosh(BigDecimal x) {
            return BigDecimalMath.cosh(x, this.mathContext);
        }

        public BigDecimal tanh(BigDecimal x) {
            return BigDecimalMath.tanh(x, this.mathContext);
        }

        public BigDecimal asinh(BigDecimal x) {
            return BigDecimalMath.asinh(x, this.mathContext);
        }

        public BigDecimal acosh(BigDecimal x) {
            return BigDecimalMath.acosh(x, this.mathContext);
        }

        public BigDecimal atanh(BigDecimal x) {
            return BigDecimalMath.atanh(x, this.mathContext);
        }

        public BigDecimal acoth(BigDecimal x) {
            return BigDecimalMath.acoth(x, this.mathContext);
        }

        public BigDecimal pi() {
            return BigDecimalMath.pi(this.mathContext);
        }

        public BigDecimal e() {
            return BigDecimalMath.e(this.mathContext);
        }

        public BigDecimal bernoulli(int n) {
            return BigDecimalMath.bernoulli(n, this.mathContext);
        }
    }
}

