/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash.util;

import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.util.TwoGeoHashBoundingBox;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BoundingBoxGeoHashIterator
implements Iterator<GeoHash> {
    private TwoGeoHashBoundingBox boundingBox;
    private GeoHash current;

    public BoundingBoxGeoHashIterator(TwoGeoHashBoundingBox bbox) {
        this.boundingBox = bbox;
        this.current = bbox.getBottomLeft();
    }

    public TwoGeoHashBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean hasNext() {
        return this.current.compareTo(this.boundingBox.getTopRight()) <= 0;
    }

    @Override
    public GeoHash next() {
        GeoHash rv = this.current;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = rv.next();
        while (this.hasNext() && !this.boundingBox.getBoundingBox().contains(this.current.getPoint())) {
            this.current = this.current.next();
        }
        return rv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

