/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.interfaces;

import coursierapi.Dependency;
import coursierapi.Fetch;
import coursierapi.FetchResult;
import coursierapi.Repository;
import coursierapi.ResolutionParams;
import coursierapi.ScalaVersion;
import coursierapi.error.CoursierError;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import scalafix.interfaces.ScalafixException;

public class ScalafixCoursier {
    private static FetchResult fetch(List<Repository> list, List<Dependency> list2, ResolutionParams resolutionParams) throws ScalafixException {
        try {
            return Fetch.create().withRepositories((Repository[])list.stream().toArray(Repository[]::new)).withDependencies((Dependency[])list2.stream().toArray(Dependency[]::new)).withResolutionParams(resolutionParams).fetchResult();
        }
        catch (CoursierError coursierError) {
            throw new ScalafixException("Failed to fetch " + list2 + "from " + list, coursierError);
        }
    }

    private static List<URL> toURLs(FetchResult fetchResult) throws ScalafixException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : fetchResult.getFiles()) {
            try {
                URL uRL = file.toURI().toURL();
                arrayList.add(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ScalafixException("Failed to load dependency " + file, malformedURLException);
            }
        }
        return arrayList;
    }

    public static List<URL> scalafixCliJars(List<Repository> list, String string, String string2) throws ScalafixException {
        Dependency dependency = Dependency.parse((String)("ch.epfl.scala:::scalafix-cli:" + string), (ScalaVersion)ScalaVersion.of((String)string2)).withConfiguration("runtime");
        return ScalafixCoursier.toURLs(ScalafixCoursier.fetch(list, Collections.singletonList(dependency), ResolutionParams.create()));
    }

    public static FetchResult toolClasspath(List<Repository> list, List<String> list2, String string) throws ScalafixException {
        ResolutionParams resolutionParams = ResolutionParams.create().addExclusion("org.scala-lang", "scala-library");
        List<Dependency> list3 = list2.stream().map(string2 -> Dependency.parse((String)string2, (ScalaVersion)ScalaVersion.of((String)string))).collect(Collectors.toList());
        return ScalafixCoursier.fetch(list, list3, resolutionParams);
    }
}

