# How to Contribute #

Patches, feature requests and other contributions are essential to keep brat
up-to-date and useful to the community at large. The brat maintainers deeply
appreciate your contributions and we want to try to make it easy for you to
contribute to the project. This document acts as a guideline for new
contributors.

## Getting Started ##

* If you don't have one, get a [GitHub Account][github_reg]
* If you have a feature request:
    * Search to check if an existing request exists on the
        [issue tracker][brat_issues], if not, file a new issue, otherwise add
        to the existing one
    * Try to motivate why you think the feature is valuable to your personal
        or group use and also to the community at large
    * Try to clearly describe the feature to an extent that it will be
        possible to implement it solely from your description
    * If possible, provide suggestions on how to implement the feature and
        mention if/how you think you can contribute towards it
* If you have found a bug:
    * Search to check if an existing report of the bug exists on the
        [issue tracker][brat_issues], if not, file a new issue, otherwise add
        to the existing one
    * Describe the bug clearly, include steps necessary to reproduce the bug
    * Mention which version or revision you observed the bug in
    * Try to mention relevant aspects of the system used to run brat,
        web server, web browser, operating system, Python version, etc.
    * If your issue is graphical in nature, please link to a screenshot of it
* If you want to hack on brat:
    * Fork the [repository][brat_repo]
    * See "Making Changes" and "Submitting Changes"

[github_reg]: https://github.com/signup/free
[brat_issues]: https://github.com/nlplab/brat/issues
[brat_repo]: https://github.com/nlplab/brat

## Making Changes ##

* Create a topic branch for your fork to which you commit your work
    * Please avoid commiting changes to your master branch as it risks mixing
        code for unrelated fixes which makes merging the changes back to the
        main brat repository more difficult
* Make commits for small logical units of code and resources
* Test code is always encouraged

## Submitting Changes ##

* When submitting changes you agree that you and your potential employeer
    agrees to make the contribution available under the same licensing
    restrictions as brat itself
* Push your changes to a topic branch in your fork
* Submit a pull request to the main brat repository
* Wait for the brat maintainers to respond to your pull request

# Developer Resources #

* [GitHub Documentation](http://help.github.com/)
* [GitHub Pull Request Documentation](http://help.github.com/send-pull-requests/)
