/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.uimafit;

import ch.epfl.bbp.uima.testutils.UimaTests;
import ch.epfl.bbp.uima.uimafit.PipelineBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.xml.sax.SAXException;

public class JcasPipelineBuilder
implements PipelineBuilder {
    private JCas jCas;
    private List<AnalysisEngineDescription> aeds = new ArrayList<AnalysisEngineDescription>();
    private AnalysisEngine[] engines = null;

    public JcasPipelineBuilder() {
    }

    public JcasPipelineBuilder(String txt) throws UIMAException {
        this.jCas = UimaTests.getTestCas(txt);
    }

    public JcasPipelineBuilder(JCas jCas) {
        this.jCas = jCas;
    }

    @Override
    public void setReader(CollectionReaderDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
    }

    @Override
    public void add(AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException, InvalidXMLException {
        if (this.engines != null) {
            throw new IllegalArgumentException("cannot add more engines after first call to process()");
        }
        this.aeds.add(aDesc);
    }

    @Override
    public void add(Class<? extends JCasAnnotator_ImplBase> annotatorClass, Object ... configurationData) throws InvalidXMLException, ResourceInitializationException, IOException, SAXException, CpeDescriptorException {
        if (this.engines != null) {
            throw new IllegalArgumentException("cannot add more engines after first call to process()");
        }
        this.add(AnalysisEngineFactory.createEngineDescription(annotatorClass, (Object[])configurationData));
    }

    public JCas process() throws CpeDescriptorException, UIMAException, IOException {
        return this.process(false);
    }

    public JCas process(boolean close) throws CpeDescriptorException, UIMAException, IOException {
        if (this.engines == null) {
            this.engines = JcasPipelineBuilder.createEngines(this.aeds.toArray(new AnalysisEngineDescription[this.aeds.size()]));
        }
        SimplePipeline.runPipeline((JCas)this.jCas, (AnalysisEngine[])this.engines);
        if (close) {
            for (AnalysisEngine engine : this.engines) {
                engine.collectionProcessComplete();
                engine.destroy();
            }
        }
        return this.jCas;
    }

    public JCas process(JCas jcas_) throws CpeDescriptorException, UIMAException, IOException {
        this.jCas = jcas_;
        return this.process();
    }

    private static AnalysisEngine[] createEngines(AnalysisEngineDescription ... descs) throws UIMAException {
        AnalysisEngine[] engines = new AnalysisEngine[descs.length];
        for (int i = 0; i < engines.length; ++i) {
            engines[i] = descs[i].isPrimitive() ? AnalysisEngineFactory.createEngine((AnalysisEngineDescription)descs[i], (Object[])new Object[0]) : AnalysisEngineFactory.createEngine((AnalysisEngineDescription)descs[i], (Object[])new Object[0]);
        }
        return engines;
    }
}

