/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.uimafit;

import ch.epfl.bbp.uima.uimafit.PipelineBuilder;
import ch.epfl.bbp.uima.uimafit.StatusCallbackListenerSlf4J;
import ch.epfl.bbp.uima.utils.StopwatchUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptionImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeInclude;
import org.apache.uima.collection.metadata.CpeIntegratedCasProcessor;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.xml.sax.SAXException;

public class CpeBuilder
implements PipelineBuilder {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    private static final String ACTION_ON_MAX_ERROR = "terminate";
    private int maxProcessingUnitThreatCount = 1;
    private final CpeDescriptionImpl cpeDesc = (CpeDescriptionImpl)CpeDescriptorFactory.produceDescriptor();
    private int maxErrors = 0;

    public CpeBuilder() {
    }

    public CpeBuilder(CollectionReaderDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        this.setReader(aDesc);
    }

    @Deprecated
    public CpeBuilder(int aMaxProcessingUnitThreatCount, CollectionReaderDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        this.setReader(aDesc);
        this.setMaxProcessingUnitThreatCount(aMaxProcessingUnitThreatCount);
    }

    public CpeBuilder setMaxProcessingUnitThreatCount(int aMaxProcessingUnitThreatCount) {
        this.maxProcessingUnitThreatCount = aMaxProcessingUnitThreatCount;
        return this;
    }

    public CpeBuilder setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
        return this;
    }

    @Override
    public void setReader(CollectionReaderDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        this.cpeDesc.setAllCollectionCollectionReaders(new CpeCollectionReader[0]);
        URL descUrl = CpeBuilder.materializeDescriptor((ResourceSpecifier)aDesc).toURI().toURL();
        CpeCollectionReader reader = CpeDescriptorFactory.produceCollectionReader((String)descUrl.toString());
        this.cpeDesc.addCollectionReader(reader);
    }

    public void setAnalysisEngineDescription(AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException, InvalidXMLException {
        this.cpeDesc.setCpeCasProcessors(null);
        this.add(aDesc);
    }

    @Override
    public void add(AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException, InvalidXMLException {
        if (aDesc.isPrimitive()) {
            CpeIntegratedCasProcessor proc = CpeBuilder.createProcessor(aDesc.getMetaData().getName(), aDesc);
            this.cpeDesc.addCasProcessor((CpeCasProcessor)proc);
        } else {
            Map delegates = aDesc.getDelegateAnalysisEngineSpecifiers();
            FixedFlow flow = (FixedFlow)aDesc.getAnalysisEngineMetaData().getFlowConstraints();
            for (String key : flow.getFixedFlow()) {
                AnalysisEngineDescription aeDesc = (AnalysisEngineDescription)delegates.get(key);
                boolean multi = aeDesc.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
                this.LOG.info((Object)("[" + key + "] runs " + (multi ? "multi-threaded" : "single-threaded")));
                CpeIntegratedCasProcessor proc = CpeBuilder.createProcessor(key, aeDesc);
                this.cpeDesc.addCasProcessor((CpeCasProcessor)proc);
            }
        }
    }

    public CollectionProcessingEngine createCpe(StatusCallbackListener aListener) throws ResourceInitializationException, CpeDescriptorException {
        ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
        if (this.maxErrors != 0) {
            for (CpeCasProcessor cpeCasProcessor : this.cpeDesc.getCpeCasProcessors().getAllCpeCasProcessors()) {
                if (this.maxErrors == -1) {
                    cpeCasProcessor.setActionOnMaxError("continue");
                    continue;
                }
                if (this.maxErrors <= 0) continue;
                cpeCasProcessor.setMaxErrorCount(this.maxErrors);
            }
        }
        if (this.maxProcessingUnitThreatCount == 0) {
            this.cpeDesc.getCpeCasProcessors().setPoolSize(3);
        } else {
            this.cpeDesc.getCpeCasProcessors().setPoolSize(this.maxProcessingUnitThreatCount + 2);
            this.cpeDesc.setProcessingUnitThreadCount(this.maxProcessingUnitThreatCount);
        }
        CollectionProcessingEngine cpe = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)this.cpeDesc, (ResourceManager)resMgr, null);
        cpe.addStatusCallbackListener(aListener);
        return cpe;
    }

    private static File materializeDescriptor(ResourceSpecifier resource) throws IOException, SAXException {
        File tempDesc = File.createTempFile("desc", ".xml");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempDesc), "UTF-8"));
        resource.toXML((Writer)out);
        out.close();
        return tempDesc;
    }

    private static CpeIntegratedCasProcessor createProcessor(String key, AnalysisEngineDescription aDesc) throws IOException, SAXException, CpeDescriptorException {
        URL descUrl = CpeBuilder.materializeDescriptor((ResourceSpecifier)aDesc).toURI().toURL();
        CpeInclude cpeInclude = UIMAFramework.getResourceSpecifierFactory().createInclude();
        cpeInclude.set(descUrl.toString());
        CpeComponentDescriptor ccd = UIMAFramework.getResourceSpecifierFactory().createDescriptor();
        ccd.setInclude(cpeInclude);
        CpeIntegratedCasProcessor proc = CpeDescriptorFactory.produceCasProcessor((String)key);
        proc.setCpeComponentDescriptor(ccd);
        proc.setAttributeValue("1", (Object)1);
        proc.setActionOnMaxError(ACTION_ON_MAX_ERROR);
        proc.setMaxErrorCount(0);
        return proc;
    }

    @Override
    public void add(Class<? extends JCasAnnotator_ImplBase> annotatorClass, Object ... configurationData) throws InvalidXMLException, ResourceInitializationException, IOException, SAXException, CpeDescriptorException {
        this.add(AnalysisEngineFactory.createEngineDescription(annotatorClass, (Object[])configurationData));
    }

    @Override
    public Boolean process() throws ResourceInitializationException, CpeDescriptorException {
        StatusCallbackListenerSlf4J listener = new StatusCallbackListenerSlf4J();
        CollectionProcessingEngine cpe = this.createCpe(listener);
        listener.setCpe(cpe);
        cpe.process();
        StatusCallbackListenerSlf4J callback = listener;
        while (!callback.isCollectionProcessComplete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("should not happen, though...");
            }
        }
        StopwatchUtils.closeAndPrint();
        return true;
    }

    public void toXML(File out) throws SAXException, IOException {
        this.cpeDesc.toXML((Writer)new FileWriter(out));
    }

    public static void runPipeline(CollectionReaderDescription crd, AnalysisEngineDescription ... aeds) throws IOException, SAXException, CpeDescriptorException, InvalidXMLException, ResourceInitializationException {
        CpeBuilder builder = new CpeBuilder(crd);
        for (AnalysisEngineDescription aed : aeds) {
            builder.add(aed);
        }
        builder.process();
    }
}

