/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.io.TextFileWriter;
import ch.epfl.bbp.uima.BlueCasUtil;
import de.julielab.jules.types.Sentence;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"de.julielab.jules.types.Sentence"}, outputs={"de.julielab.jules.types.Sentence"})
public class SentenceFilterAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputDir", defaultValue={"target/"})
    private String outputDir;
    public static final String PARAM_REGEX = "regex";
    @ConfigurationParameter(name="regex", description="Regex that should find() in the desired sentences")
    private String regex;
    private Pattern pattern;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.pattern = Pattern.compile(this.regex);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        StringBuilder sb = new StringBuilder();
        for (Sentence s : JCasUtil.select((JCas)jCas, Sentence.class)) {
            if (!this.pattern.matcher(s.getCoveredText()).find()) continue;
            sb.append(s.getCoveredText().replaceAll("[\t\r\n]", " ") + " ");
        }
        try {
            int pmId = BlueCasUtil.getHeaderIntDocId(jCas);
            TextFileWriter.write((File)new File(this.outputDir + "/" + pmId + ".tsv"), (String)(pmId + "\t" + sb.toString().trim()));
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

