/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.serialization;

import ch.epfl.bbp.uima.ae.serialization.BinaryCasReader;
import ch.epfl.bbp.uima.utils.Preconditions;
import ch.epfl.bbp.uima.utils.StructuredDirectory;
import java.io.File;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeBinaryCasReader
extends JCasCollectionReader_ImplBase {
    protected static final Logger LOG = LoggerFactory.getLogger(RangeBinaryCasReader.class);
    @ConfigurationParameter(name="inputDirectory", description="path to a StructuredDirectory containing serialized CASes")
    protected String inputDir;
    @ConfigurationParameter(name="between", description="specifies a range of pubmed_id, e.g. {13,17} --> 13 <= pubmed_id <= 17")
    private int[] btw;
    int nextPmId;
    int maxPmId;
    File next;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        com.google.common.base.Preconditions.checkArgument((this.btw.length == 2 ? 1 : 0) != 0, (Object)("PARAM_BETWEEN should be length 2, " + this.btw));
        com.google.common.base.Preconditions.checkArgument((this.btw[0] < this.btw[1] ? 1 : 0) != 0, (Object)("PARAM_BETWEEN[0] should be < PARAM_BETWEEN[1], " + this.btw));
        this.nextPmId = this.btw[0];
        this.maxPmId = this.btw[1];
        Preconditions.checkFileExists(this.inputDir);
    }

    public boolean hasNext() throws IOException, CollectionException {
        for (int i = this.nextPmId; i < this.maxPmId; ++i) {
            String path = StructuredDirectory.getFilePath(i, "gz");
            File f = new File(this.inputDir + "/" + path);
            if (!f.exists()) continue;
            this.nextPmId = i + 1;
            this.next = f;
            return true;
        }
        return false;
    }

    public Progress[] getProgress() {
        return null;
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        try {
            BinaryCasReader.deserialize(this.next, jCas);
        }
        catch (Exception e) {
            LOG.error("could not read serialized cas at " + this.next.getAbsolutePath(), (Throwable)e);
        }
    }
}

