/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.types.Cooccurrence;
import com.google.common.collect.Lists;
import de.julielab.jules.types.Sentence;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class FilterCoocurrencesIfTooManyEntities
extends JCasAnnotator_ImplBase {
    public static final String PARAM_MAXIMUM_ENTITIES = "maximumEntities";
    @ConfigurationParameter(name="maximumEntities", defaultValue={"5"}, mandatory=false, description="the maximum number of enclosed annotations (e.g. brain regions) mentions allowed per enclosing scope. If more, delete ALL co-occurrences in the enclosing scope.")
    protected int maximumDistance;
    @ConfigurationParameter(name="annotationClass", defaultValue={"ch.epfl.bbp.uima.types.BrainRegion"}, mandatory=false, description="the enclosed annotation")
    protected String annotationStr;
    protected Class<Annotation> annotation;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.annotation = Class.forName(this.annotationStr);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        LinkedList toRemove = Lists.newLinkedList();
        Map sentenceWithBr = JCasUtil.indexCovered((JCas)jCas, Sentence.class, this.annotation);
        for (Map.Entry sentenceWithCooc : JCasUtil.indexCovered((JCas)jCas, Sentence.class, Cooccurrence.class).entrySet()) {
            int nrBr;
            Sentence s = (Sentence)sentenceWithCooc.getKey();
            if (!sentenceWithBr.containsKey(s) || (nrBr = ((Collection)sentenceWithBr.get(s)).size()) <= this.maximumDistance) continue;
            toRemove.addAll((Collection)sentenceWithCooc.getValue());
        }
        Cooccurrence[] array = toRemove.toArray(new Cooccurrence[toRemove.size()]);
        for (int i = 0; i < array.length; ++i) {
            array[i].removeFromIndexes();
        }
    }
}

