/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.relations;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.ae.relations.CooccurrencesEvaluationAnnotator;
import ch.epfl.bbp.uima.types.Cooccurrence;
import ch.epfl.bbp.uima.typesystem.To;
import ch.epfl.bbp.uima.validation.TestEvaluator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Cooccurrence"})
public class CooccurrencesEvaluationAnnotator2
extends JCasAnnotator_ImplBase {
    protected static Logger LOG = LoggerFactory.getLogger(CooccurrencesEvaluationAnnotator2.class);
    private static final String VIEW1 = "topdown";
    private static final String VIEW2 = "kernel";
    private static final String VIEW3 = "rules";
    private static final String PARAM_EXTRACTOR_SETUP = "extractorSetup";
    @ConfigurationParameter(name="extractorSetup", description="e.g. 0 0 1, or best")
    private String extractorSetupStr;
    private TestEvaluator<Annotation, Annotation> evaluator = CooccurrencesEvaluationAnnotator.getEvaluator();

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int pmId = BlueCasUtil.getHeaderIntDocId(jCas);
        try {
            JCas view1 = jCas.getView(VIEW1);
            JCas view2 = jCas.getView(VIEW2);
            JCas view3 = jCas.getView(VIEW3);
            JCas goldView = jCas.getView("view_gold");
            Collection goldAnnot = JCasUtil.select((JCas)goldView, Cooccurrence.class);
            ArrayList systAnnot = Lists.newArrayList();
            Collection first = JCasUtil.select((JCas)view1, Cooccurrence.class);
            Collection second = JCasUtil.select((JCas)view2, Cooccurrence.class);
            Collection third = JCasUtil.select((JCas)view3, Cooccurrence.class);
            CooccurrencesEvaluationAnnotator2.print(pmId + " GOLD::");
            for (Object c : goldAnnot) {
                CooccurrencesEvaluationAnnotator2.print(To.string(c));
            }
            CooccurrencesEvaluationAnnotator2.print(pmId + " FIRST::");
            for (Object c : first) {
                CooccurrencesEvaluationAnnotator2.print(To.string(c));
            }
            CooccurrencesEvaluationAnnotator2.print(pmId + " SECOND::");
            for (Object c : second) {
                CooccurrencesEvaluationAnnotator2.print(To.string(c));
            }
            CooccurrencesEvaluationAnnotator2.print(pmId + " THIRD::");
            for (Object c : third) {
                CooccurrencesEvaluationAnnotator2.print(To.string(c));
            }
            LinkedList union = Lists.newLinkedList();
            for (Object c : first) {
                if (CooccurrencesEvaluationAnnotator.contains(union, c)) continue;
                union.add(c);
            }
            for (Object c : second) {
                if (CooccurrencesEvaluationAnnotator.contains(union, c)) continue;
                union.add(c);
            }
            for (Object c : third) {
                if (CooccurrencesEvaluationAnnotator.contains(union, c)) continue;
                union.add(c);
            }
            CooccurrencesEvaluationAnnotator2.print(pmId + " UNION::");
            for (Object c : union) {
                CooccurrencesEvaluationAnnotator2.print(To.string((Object)c));
            }
            for (Object c : union) {
                if (this.extractorSetupStr.equals("1 1 1")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(first, c) || !CooccurrencesEvaluationAnnotator.contains(second, c) || !CooccurrencesEvaluationAnnotator.contains(third, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("1 1 0")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(first, c) || !CooccurrencesEvaluationAnnotator.contains(second, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("1 0 1")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(first, c) || !CooccurrencesEvaluationAnnotator.contains(third, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("1 0 0")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(first, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("0 1 1")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(second, c) || !CooccurrencesEvaluationAnnotator.contains(third, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("0 1 0")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(second, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("0 0 1")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(third, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                if (this.extractorSetupStr.equals("best")) {
                    if (!CooccurrencesEvaluationAnnotator.contains(first, c) && !CooccurrencesEvaluationAnnotator.contains(second, c) || !CooccurrencesEvaluationAnnotator.contains(third, c)) continue;
                    systAnnot.add(c);
                    continue;
                }
                throw new Exception("config wrong: " + this.extractorSetupStr);
            }
            CooccurrencesEvaluationAnnotator2.print(pmId + " SYSTEM::");
            for (Object c : systAnnot) {
                CooccurrencesEvaluationAnnotator2.print(To.string((Object)c));
            }
            CooccurrencesEvaluationAnnotator2.print("comparing #gold:" + goldAnnot.size() + " #sys:" + systAnnot.size());
            CooccurrencesEvaluationAnnotator2.print(this.evaluator.add(goldAnnot, systAnnot, pmId + ""));
        }
        catch (Exception e) {
            LOG.error("something went wrong with " + pmId, (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        System.out.println(this.evaluator.compare());
    }
}

