/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.io.LineReader;
import ch.epfl.bbp.io.TextFileWriter;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.Keep;
import ch.epfl.bbp.uima.utils.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Keep"})
public class LdaCWriter
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputFile", mandatory=true)
    private String outputFile;
    public static final String PARAM_VOCABULARY_OUTPUT_FILE = "vocabularyOutputFile";
    @ConfigurationParameter(name="vocabularyOutputFile", mandatory=false)
    private String vocabularyOutputFile;
    public static final String PARAM_VOCABULARY_INPUT_FILE = "vocabularyInputFile";
    @ConfigurationParameter(name="vocabularyInputFile", mandatory=false)
    private String vocabularyInputFile;
    public static final String PARAM_IDS_OUTPUT_FILE = "idsOutputFile";
    @ConfigurationParameter(name="idsOutputFile", mandatory=false, description="(optional) outputs a list of pmids alongside")
    private String idsOutputFile;
    public static final String PARAM_DCA_FORMAT = "dcaFormat";
    @ConfigurationParameter(name="dcaFormat", defaultValue={"false"}, description="wheter to output in DCA format (without ':')")
    private boolean dcaFormat;
    private Writer writer;
    private TextFileWriter idsWriter = null;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        com.google.common.base.Preconditions.checkArgument((boolean)(this.vocabularyInputFile == null ^ this.vocabularyOutputFile == null), (Object)"please provide either input or output vocabulary file ");
        try {
            String separator;
            String string = separator = this.dcaFormat ? " " : ":";
            if (this.idsOutputFile != null) {
                this.idsWriter = new TextFileWriter(new File(this.idsOutputFile));
            }
            if (this.vocabularyOutputFile != null) {
                this.writer = new Writer(separator, this.outputFile, this.vocabularyOutputFile);
            } else {
                Preconditions.checkFileExists(this.vocabularyInputFile);
                this.writer = new Writer(separator, this.outputFile, LineReader.linesFrom((String)new File(this.vocabularyInputFile).getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            LinkedList words = Lists.newLinkedList();
            for (Keep k : JCasUtil.select((JCas)jCas, Keep.class)) {
                words.add(k.getNormalizedText().replace(' ', '_'));
            }
            if (!words.isEmpty() && this.writer.addDocument(words) && this.idsWriter != null) {
                this.idsWriter.addLine(BlueCasUtil.getHeaderDocId(jCas));
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.writer.close();
            if (this.idsWriter != null) {
                this.idsWriter.close();
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public static class Writer {
        private String separator;
        private Map<String, Integer> vocabulary = Maps.newLinkedHashMap();
        private boolean vocabularyClosed = false;
        private PrintWriter corpusWriter;
        private String vocabularyOutputFile = null;

        public Writer(String separator, String outputFile, String vocabularyOutputFile) throws IOException {
            this.separator = separator;
            this.corpusWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(outputFile))));
            this.vocabularyOutputFile = vocabularyOutputFile;
        }

        public Writer(String separator, String outputFile, List<String> providedVocabulary) throws IOException {
            this.separator = separator;
            this.corpusWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(outputFile))));
            for (int i = 0; i < providedVocabulary.size(); ++i) {
                this.vocabulary.put(providedVocabulary.get(i), i);
            }
            this.vocabularyClosed = true;
        }

        public boolean addDocument(List<String> words) {
            HashMap documentMap = Maps.newHashMap();
            for (String string : words) {
                Integer cnt;
                Integer tokenId = this.vocabulary.get(string);
                if (tokenId == null && this.vocabularyClosed) continue;
                if (tokenId == null && !this.vocabularyClosed) {
                    tokenId = this.vocabulary.size();
                    this.vocabulary.put(string, tokenId);
                }
                if ((cnt = (Integer)documentMap.get(tokenId)) == null) {
                    documentMap.put(tokenId, 1);
                    continue;
                }
                documentMap.put(tokenId, cnt + 1);
            }
            if (!documentMap.isEmpty()) {
                this.corpusWriter.print(documentMap.size());
                for (Map.Entry entry : documentMap.entrySet()) {
                    this.corpusWriter.print(" " + entry.getKey() + this.separator + entry.getValue());
                }
                this.corpusWriter.println();
                return true;
            }
            return false;
        }

        public void close() throws IOException {
            this.corpusWriter.close();
            if (!this.vocabularyClosed) {
                PrintWriter vocabWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.vocabularyOutputFile))));
                for (String vocabEntry : this.vocabulary.keySet()) {
                    vocabWriter.println(vocabEntry);
                }
                vocabWriter.close();
            }
        }
    }
}

