/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.BlueUima;
import ch.epfl.bbp.uima.typesystem.TypeSystemSemantics;
import com.google.common.collect.Sets;
import de.julielab.jules.types.Token;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.type.BREAK;

@TypeCapability(inputs={"de.julielab.jules.types.Token"})
public class HtmlViewerWriter
extends JCasAnnotator_ImplBase {
    final String css = BlueUima.BLUE_UTILS_ROOT + "src/main/resources/html_viewer/style.css";
    @ConfigurationParameter(name="outputDir", defaultValue={"target/htmlViewer/"}, description="output directory , defaults to target/htmlViewer")
    private String outputDir;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            FileUtils.forceMkdir((File)new File(this.outputDir));
            FileUtils.copyFile((File)new File(this.css), (File)new File(this.outputDir + "style.css"));
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            String pmId = BlueCasUtil.getHeaderDocId(jCas);
            if (pmId == null) {
                pmId = BlueCasUtil.getHeaderSource(jCas);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputDir + pmId + ".html"));
            writer.append("<html><body><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\"><link href=\"http://netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css\" rel=\"stylesheet\"></head><body><div class=\"container\">\n");
            Map index = CasUtil.indexCovering((CAS)jCas.getCas(), (Type)JCasUtil.getType((JCas)jCas, Token.class), (Type)JCasUtil.getType((JCas)jCas, Annotation.class));
            HashSet breaks = Sets.newHashSet();
            for (BREAK b : JCasUtil.select((JCas)jCas, BREAK.class)) {
                breaks.add(b.getBegin());
            }
            HashSet lastTokenClasses = Sets.newHashSet();
            for (Token t : JCasUtil.select((JCas)jCas, Token.class)) {
                HashSet annots = Sets.newHashSet();
                for (AnnotationFS a : (Collection)index.get(t)) {
                    if (TypeSystemSemantics.NON_CONTENT_ANNOTATIONS_OR_TOKEN.contains(a.getType().getName())) continue;
                    annots.add(a.getType().getShortName());
                }
                Sets.SetView shared = Sets.intersection((Set)annots, (Set)lastTokenClasses);
                lastTokenClasses = annots;
                writer.append("<span  title=\"" + StringUtils.join((Collection)shared, (String)", ") + "\" class=\"an " + StringUtils.join((Collection)shared, (String)" ") + "\">&ensp;</span>");
                if (!annots.isEmpty()) {
                    writer.append("<span  title=\"" + StringUtils.join((Collection)annots, (String)", ") + "\" class=\"an " + StringUtils.join((Collection)annots, (String)" ") + "\">" + t.getCoveredText() + "</span>");
                } else {
                    writer.append(t.getCoveredText() + " ");
                }
                if (!breaks.contains(t.getEnd())) continue;
                writer.append("<br/>");
                lastTokenClasses.clear();
            }
            writer.append("\n</div></body></html>");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

