/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae.output;

import ch.epfl.bbp.uima.utils.LoadDataFileWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
public class CountAnnotations
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(CountAnnotations.class);
    @ConfigurationParameter(name="outputFile")
    private String outFile;
    @ConfigurationParameter(name="annotationClasses", description="annotation classes name to count")
    private String[] annotationClassesStr;
    private List<Class<? extends Annotation>> annotationClasses = Lists.newArrayList();
    private LoadDataFileWriter writer;
    private int docCnt = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        Preconditions.checkArgument((this.annotationClassesStr.length > 0 ? 1 : 0) != 0, (Object)"no annotations provided");
        try {
            ArrayList fields = Lists.newArrayList();
            for (String c : this.annotationClassesStr) {
                try {
                    Class<?> ac = Class.forName(c);
                    this.annotationClasses.add(ac);
                    fields.add(ac.getSimpleName());
                }
                catch (Exception e) {
                    throw new Exception("Could not instantialize class " + c);
                }
            }
            LOG.info("writing annotations file to {}", (Object)this.outFile);
            this.writer = new LoadDataFileWriter(new File(this.outFile), "\t", fields.toArray(new String[fields.size()]));
        }
        catch (Throwable t) {
            throw new ResourceInitializationException(t);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Object[] cnts = new Object[this.annotationClasses.size()];
        for (int i = 0; i < this.annotationClasses.size(); ++i) {
            Class<? extends Annotation> ac = this.annotationClasses.get(i);
            Collection matches = JCasUtil.select((JCas)jCas, ac);
            cnts[i] = matches != null && !matches.isEmpty() ? Integer.valueOf(matches.size()) : Integer.valueOf(0);
        }
        this.writer.addLoadLine(cnts);
        if (++this.docCnt % 1000 == 0) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

