/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import com.google.common.base.Preconditions;
import javax.management.RuntimeErrorException;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAnnotator
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(TestAnnotator.class);
    @ConfigurationParameter(name="expects", mandatory=true, description="pour le premier document: [{annot} {expected_count}, ]* , e.g. de.julielab.jules.types.Token 10, ch.epfl.bbp.uima.types.GeneralEnglish 4")
    private String expects;
    @ConfigurationParameter(name="expects2", mandatory=false, description="pour le second document: [{annot} {expected_count}, ]* , e.g. de.julielab.jules.types.Token 10, ch.epfl.bbp.uima.types.GeneralEnglish 4")
    private String expects2;
    @ConfigurationParameter(name="expects3", mandatory=false, description="pour le 3eme document: [{annot} {expected_count}, ]* , e.g. de.julielab.jules.types.Token 10, ch.epfl.bbp.uima.types.GeneralEnglish 4")
    private String expects3;
    @ConfigurationParameter(name="expects4", mandatory=false, description="pour le 4eme document: [{annot} {expected_count}, ]* , e.g. de.julielab.jules.types.Token 10, ch.epfl.bbp.uima.types.GeneralEnglish 4")
    private String expects4;
    @ConfigurationParameter(name="expects5", mandatory=false, description="pour le 5eme document: [{annot} {expected_count}, ]* , e.g. de.julielab.jules.types.Token 10, ch.epfl.bbp.uima.types.GeneralEnglish 4")
    private String expects5;
    int doc = 0;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String[] expectationsArr = new String[]{this.expects, this.expects2, this.expects3, this.expects4, this.expects5};
        String documentExpect = expectationsArr[this.doc];
        ++this.doc;
        if (documentExpect != null) {
            String[] expectations;
            for (String expectation : expectations = documentExpect.split(", ")) {
                Preconditions.checkArgument((expectation.indexOf(" ") > -1 ? 1 : 0) != 0, (Object)("format is [{annot} {expected_count}, ]*, but it was " + expectation));
                String[] e = expectation.split(" ");
                Preconditions.checkArgument((e.length == 2 ? 1 : 0) != 0, (Object)("format is [{annot} {expected_count}, ]*, but it was " + expectation));
                String annot = e[0];
                Preconditions.checkArgument((boolean)StringUtils.isNumeric((String)e[1]), (Object)("expected_count shoud be numeric, but it was " + e[1]));
                int expected = Integer.parseInt(e[1]);
                LOG.debug("TEST let's see if i can find {} annotation(s) of type {} here?", (Object)expected, (Object)annot);
                try {
                    Class<?> annotClass = Class.forName(annot);
                    int actual = JCasUtil.select((JCas)jCas, annotClass).size();
                    if (actual == expected) continue;
                    String found = "";
                    for (Annotation a : JCasUtil.select((JCas)jCas, annotClass)) {
                        found = found + a.getCoveredText() + "\n";
                    }
                    String msg = "FATAL ERROR [TestAnnotator] assertion failed: found " + actual + " " + annot + " instead of " + expected + ", found:\n" + found;
                    System.err.println(msg);
                    throw new RuntimeErrorException(null, msg);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("could not load class " + annot);
                }
            }
        }
    }
}

