/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.ae.GarbageCollectorAnnotator;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperationalProperties(multipleDeploymentAllowed=false)
public class StatsAnnotatorPlus
extends JCasAnnotator_ImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(StatsAnnotatorPlus.class);
    public static final String PARAM_PRINT_EVERY = "printEvery";
    @ConfigurationParameter(name="printEvery", defaultValue={"1000"}, description="print every n doc")
    private int printEvery;
    private ThreadMXBean threadMXBean;
    private DecimalFormat df = new DecimalFormat("#.##");
    private int cnt;
    private Long start = null;
    private long lastProcess;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.start = null;
        this.cnt = 0;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (this.start == null) {
            this.start = System.currentTimeMillis();
        }
        if (!BlueCasUtil.isEmptyText(jCas)) {
            ++this.cnt;
        }
        if (this.cnt % this.printEvery == 0) {
            double sinceLastProcess;
            String docs_s = "";
            double since_start = ((double)(System.currentTimeMillis() - this.start) + 0.0) / 1000.0;
            if (since_start > 0.0) {
                docs_s = docs_s + this.df.format(((double)this.cnt + 0.0) / since_start);
            }
            if ((sinceLastProcess = ((double)(System.currentTimeMillis() - this.lastProcess) + 0.0) / 1000.0) > 0.0) {
                docs_s = docs_s + "\t" + this.df.format(((double)this.printEvery + 0.0) / sinceLastProcess);
            }
            this.lastProcess = System.currentTimeMillis();
            LOG.info("~STATS pmid:{}\t#docs:{}\tdoc\\s:{}\t#threads:{}\tfree_mem:{}\tmax_mem:{}", new Object[]{BlueCasUtil.getHeaderDocId(jCas), this.cnt, docs_s, this.threadMXBean.getThreadCount(), GarbageCollectorAnnotator.freeMemory(), GarbageCollectorAnnotator.maxMemory()});
        }
    }
}

