/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import ch.epfl.bbp.uima.types.POSAdverb;
import ch.epfl.bbp.uima.types.POSSkip;
import ch.epfl.bbp.uima.types.POSVerb;
import ch.epfl.bbp.uima.types.POSWh;
import com.google.common.collect.Sets;
import de.julielab.jules.types.Token;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@TypeCapability(inputs={"de.julielab.jules.types.Token"}, outputs={"ch.epfl.bbp.uima.types.POSVerb", "de.julielab.jules.types.POSTag"})
public class SkipSomePosAnnotator
extends JCasAnnotator_ImplBase {
    public static final Set<String> POS_SKIP = Sets.newHashSet((Object[])new String[]{"CC", "DT", "EX", "IN", "LS", "MD", "PDT", "POS", "PRP", "PRP$", "RP", "TO"});

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Token t : JCasUtil.select((JCas)jCas, Token.class)) {
            String pos = t.getPos();
            if (pos == null) {
                pos = "UNKNOWN";
            }
            if (pos.startsWith("V")) {
                new POSVerb(jCas, t.getBegin(), t.getEnd()).addToIndexes();
                continue;
            }
            if (pos.startsWith("W")) {
                new POSWh(jCas, t.getBegin(), t.getEnd()).addToIndexes();
                continue;
            }
            if (pos.startsWith("R")) {
                new POSAdverb(jCas, t.getBegin(), t.getEnd()).addToIndexes();
                continue;
            }
            if (!POS_SKIP.contains(pos)) continue;
            new POSSkip(jCas, t.getBegin(), t.getEnd()).addToIndexes();
        }
    }
}

