/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.ae;

import com.google.common.collect.Lists;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class RemoveAnnotationsAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="annotationClass", mandatory=true, description="The name (including package) of the class to be detagged, use: MyClass.class.getName(), or 'all' to remove ALL annotations")
    private String className = null;
    private Class<? extends Annotation> aClass;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            if (!this.className.equals("all")) {
                this.aClass = Class.forName(this.className);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("could not find class " + this.className);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (this.className.equals("all")) {
            for (TOP t : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, TOP.class))) {
                t.removeFromIndexes();
            }
        } else {
            for (Annotation a : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, this.aClass))) {
                a.removeFromIndexes();
            }
        }
    }
}

