/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.word2vec;

import ch.epfl.bbp.uima.word2vec.Word2Vec;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Word2VecUtils {
    private static Logger LOG = LoggerFactory.getLogger(Word2VecUtils.class);
    static final String MODEL_FILE = "/Users/richarde/data_hdd/word2vec_models/vectors.bin";
    private static Word2Vec w2v = new Word2Vec();
    static final String MODEL_FILE_CLASS = "/Volumes/HDD2/ren_data/dev_hdd/bluebrain/9_lda/50_word2vec/word2vec_trunk/1m_ns.w2v.100classes.bin";
    private static HashMap<String, Integer> w2c;

    private Word2VecUtils() {
    }

    public static float[] getWordVector(String word) {
        return w2v.getWordVector(word.toLowerCase());
    }

    public static int getClass(String word) {
        if (w2c == null) {
            try {
                w2c = Word2Vec.loadClassModel(MODEL_FILE_CLASS);
            }
            catch (IOException e) {
                System.err.println("could not load w2c");
            }
        }
        if (w2c.containsKey(word.toLowerCase())) {
            return w2c.get(word.toLowerCase());
        }
        return -1;
    }

    static {
        try {
            w2v.loadModel(MODEL_FILE);
        }
        catch (IOException e) {
            LOG.error("could not load model", (Throwable)e);
        }
        w2c = null;
    }
}

