/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.word2vec;

import ch.epfl.bbp.uima.word2vec.Word2Vec;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Word2VecMore
extends Word2Vec {
    public Set<Word2Vec.WordEntry> distanceNeg(String word) {
        float[] wordVector = this.getWordVector(word);
        if (wordVector == null) {
            return null;
        }
        Set entrySet = this.vocabulary.entrySet();
        float[] tempVector = null;
        ArrayList<Word2Vec.WordEntry> wordEntrys = new ArrayList<Word2Vec.WordEntry>(this.topNSize);
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            if (name.equals(word)) continue;
            float dist = 0.0f;
            tempVector = (float[])entry.getValue();
            for (int i = 0; i < wordVector.length; ++i) {
                float thisDist = wordVector[i] * tempVector[i];
                if (!(thisDist < 0.0f)) continue;
                dist += thisDist;
            }
            this.insertTopN(name, dist, wordEntrys);
        }
        return new TreeSet<Word2Vec.WordEntry>(wordEntrys);
    }

    public Set<Word2Vec.WordEntry> distanceNegCnt(String word) {
        float[] wordVector = this.getWordVector(word);
        if (wordVector == null) {
            return null;
        }
        Set entrySet = this.vocabulary.entrySet();
        float[] tempVector = null;
        ArrayList<Word2Vec.WordEntry> wordEntrys = new ArrayList<Word2Vec.WordEntry>(this.topNSize);
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            if (name.equals(word)) continue;
            int negatives = 0;
            tempVector = (float[])entry.getValue();
            for (int i = 0; i < wordVector.length; ++i) {
                float thisDist = wordVector[i] * tempVector[i];
                if (!(thisDist < 0.0f)) continue;
                ++negatives;
            }
            this.insertTopN(name, -negatives, wordEntrys);
        }
        return new TreeSet<Word2Vec.WordEntry>(wordEntrys);
    }

    public Set<Word2Vec.WordEntry> distanceMax(String word) {
        float[] wordVector = this.getWordVector(word);
        if (wordVector == null) {
            return null;
        }
        Set entrySet = this.vocabulary.entrySet();
        float[] tempVector = null;
        ArrayList<Word2Vec.WordEntry> wordEntrys = new ArrayList<Word2Vec.WordEntry>(this.topNSize);
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            if (name.equals(word)) continue;
            float minDist = 10.0f;
            float maxDist = -10.0f;
            tempVector = (float[])entry.getValue();
            for (int i = 0; i < wordVector.length; ++i) {
                maxDist = Math.max(wordVector[i] * tempVector[i], maxDist);
                minDist = Math.min(wordVector[i] * tempVector[i], minDist);
            }
            this.insertTopN(name, maxDist + minDist, wordEntrys);
        }
        return new TreeSet<Word2Vec.WordEntry>(wordEntrys);
    }
}

