/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.validation;

import ch.epfl.bbp.uima.validation.Comparator;
import ch.epfl.bbp.uima.validation.TestResult;
import java.util.Collection;
import org.apache.uima.jcas.tcas.Annotation;

public class TestEvaluator<T extends Annotation, U extends Annotation> {
    private final Comparator<T, U> comparator;
    private int expectedCnt = 0;
    private int actualCnt = 0;
    private int truePositives = 0;
    private int falseNegatives = 0;
    private int falsePositives = 0;

    public TestEvaluator(Comparator<T, U> comparator) {
        this.comparator = comparator;
    }

    public Comparator<T, U> getComparator() {
        return this.comparator;
    }

    public String add(Collection<T> expecteds, Collection<U> actuals, String pmId) {
        StringBuilder sb = new StringBuilder();
        int _truePositives = 0;
        int _falseNegatives = 0;
        boolean expectedsCnt = false;
        for (Annotation expected : expecteds) {
            boolean _localFN = true;
            for (Annotation actual : actuals) {
                if (!this.comparator.areTheSame(expected, actual)) continue;
                ++_truePositives;
                _localFN = false;
                break;
            }
            if (!_localFN) continue;
            ++_falseNegatives;
            sb.append("fn: " + expected.getCoveredText() + "\n");
        }
        int _falsePositives = 0;
        for (Annotation actual : actuals) {
            boolean _localFP = false;
            for (Annotation expected : expecteds) {
                if (!this.comparator.areTheSame(expected, actual)) continue;
                _localFP = true;
                break;
            }
            if (!(!_localFP)) continue;
            ++_falsePositives;
            sb.append("fp: " + actual.getCoveredText() + "\n");
        }
        this.truePositives += _truePositives;
        this.falsePositives += _falsePositives;
        this.falseNegatives += _falseNegatives;
        this.expectedCnt += expecteds.size();
        this.actualCnt += actuals.size();
        sb.append("tp:" + _truePositives + " fp:" + _falsePositives + " fn:" + _falseNegatives + "\n");
        return sb.toString();
    }

    public TestResult compare() {
        if (this.expectedCnt == 0 || this.actualCnt == 0) {
            return new TestResult(0, 0, 0.0, 0.0);
        }
        double precision = ((double)this.truePositives + 0.0) / ((double)(this.truePositives + this.falsePositives) + 0.0);
        double recall = ((double)this.truePositives + 0.0) / ((double)this.expectedCnt + 0.0);
        return new TestResult(this.expectedCnt, this.actualCnt, precision, recall);
    }

    public static <A extends Annotation> TestEvaluator<A, A> getSimpleEvaluator() {
        Comparator simpleComparator = new Comparator<A, A>(){

            @Override
            public boolean areTheSame(A expected, A actual) {
                return expected.getBegin() == actual.getBegin() && expected.getEnd() == actual.getEnd();
            }
        };
        return new TestEvaluator(simpleComparator);
    }

    public static <A extends Annotation, B extends Annotation> TestEvaluator<A, B> getExactEvaluator() {
        Comparator simpleComparator = new Comparator<A, B>(){

            @Override
            public boolean areTheSame(A expected, B actual) {
                return expected.getBegin() == actual.getBegin() && expected.getEnd() == actual.getEnd();
            }
        };
        return new TestEvaluator(simpleComparator);
    }

    public static <A extends Annotation, B extends Annotation> TestEvaluator<A, B> getAtLeastCoveredEvaluator() {
        Comparator simpleComparator = new Comparator<A, B>(){

            @Override
            public boolean areTheSame(A expected, B actual) {
                return expected.getBegin() >= actual.getBegin() && expected.getEnd() <= actual.getEnd();
            }
        };
        return new TestEvaluator(simpleComparator);
    }

    public static <A extends Annotation, B extends Annotation> TestEvaluator<A, B> getAtLeastCoveringEvaluator() {
        Comparator simpleComparator = new Comparator<A, B>(){

            @Override
            public boolean areTheSame(A expected, B actual) {
                return expected.getBegin() <= actual.getBegin() && expected.getEnd() >= actual.getEnd();
            }
        };
        return new TestEvaluator(simpleComparator);
    }

    public static <A extends Annotation, B extends Annotation> TestEvaluator<A, B> getOverlapEvaluator() {
        Comparator simpleComparator = new Comparator<A, B>(){

            @Override
            public boolean areTheSame(A expected, B actual) {
                return expected.getBegin() < actual.getEnd() && expected.getEnd() > actual.getBegin();
            }
        };
        return new TestEvaluator(simpleComparator);
    }
}

