/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.validation;

import ch.epfl.bbp.uima.ae.serialization.BinaryCasWriter;
import java.io.File;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
@OperationalProperties(multipleDeploymentAllowed=false)
public class CrossvalidationWriter
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(CrossvalidationWriter.class);
    @ConfigurationParameter(name="corpusName")
    private String corpusName;
    private File store;
    private int docId;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.store = new File("target/crossvalidation_" + this.corpusName);
        this.docId = 0;
        if (this.store.exists()) {
            throw new RuntimeException("corpus exists at " + this.store.getPath());
        }
        LOG.warn("creating Cross-Validation data in {}", (Object)this.store.getPath());
        this.store.mkdirs();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        File file = new File(this.store, this.docId + ".gz");
        try {
            BinaryCasWriter.serialize(jCas, file);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        ++this.docId;
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        LOG.warn("Persisting corpus done, added {} documents in {}", (Object)this.docId, (Object)this.store.getPath());
    }
}

