/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.validation;

import ch.epfl.bbp.uima.validation.TestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.jcas.tcas.Annotation;

public class AlternateTestEvaluator<T extends Annotation> {
    private int expectedCnt = 0;
    private int actualCnt = 0;
    private int truePositives = 0;
    private int falsePositives = 0;

    public String add(Collection<T> expecteds, Collection<T> actuals) {
        StringBuilder sb = new StringBuilder();
        LinkedList<Alternatives<Annotation>> altExpecteds = new LinkedList<Alternatives<Annotation>>();
        for (Annotation expected : expecteds) {
            boolean bl = false;
            for (Alternatives alternatives : altExpecteds) {
                if (!alternatives.canFitIn(expected)) continue;
                bl = true;
                alternatives.add(expected);
                break;
            }
            if (bl) continue;
            altExpecteds.add(new Alternatives<Annotation>(expected));
        }
        int _truePositives = 0;
        block2: for (Alternatives alternatives : altExpecteds) {
            for (Annotation annotation : actuals) {
                if (!alternatives.matches(annotation)) continue;
                ++_truePositives;
                continue block2;
            }
        }
        int _falsePositives = 0;
        for (Annotation actual : actuals) {
            boolean bl = false;
            for (Alternatives alternatives : altExpecteds) {
                if (!alternatives.matches(actual)) continue;
                bl = true;
                break;
            }
            if (!(!bl)) continue;
            ++_falsePositives;
            sb.append("fp: " + actual.getCoveredText());
        }
        this.truePositives += _truePositives;
        this.falsePositives += _falsePositives;
        this.expectedCnt += altExpecteds.size();
        this.actualCnt += actuals.size();
        sb.append("--> tp:" + _truePositives + " fp:" + _falsePositives);
        return sb.toString();
    }

    public TestResult compare() {
        if (this.expectedCnt == 0 || this.actualCnt == 0) {
            return new TestResult(0, 0, 0.0, 0.0);
        }
        double precision = ((double)this.truePositives + 0.0) / ((double)(this.truePositives + this.falsePositives) + 0.0);
        double recall = ((double)this.truePositives + 0.0) / ((double)this.expectedCnt + 0.0);
        return new TestResult(this.expectedCnt, this.actualCnt, precision, recall);
    }

    private static class Alternatives<T extends Annotation> {
        List<T> altForms = new ArrayList<T>();
        int min = 0;
        int max = 0;

        public Alternatives(T firstElement) {
            this.altForms.add(firstElement);
            this.min = firstElement.getBegin();
            this.max = firstElement.getEnd();
        }

        boolean canFitIn(T t) {
            return t.getBegin() < this.max && t.getEnd() > this.min || t.getEnd() > this.min && t.getBegin() < this.max;
        }

        void add(T t) {
            this.altForms.add(t);
            this.min = Math.min(this.min, t.getBegin());
            this.max = Math.max(this.max, t.getEnd());
        }

        boolean matches(T t) {
            boolean matches = false;
            for (Annotation alt : this.altForms) {
                if (alt.getBegin() != t.getBegin() || alt.getEnd() != t.getEnd()) continue;
                matches = true;
                break;
            }
            return matches;
        }

        public String toString() {
            String list = " ";
            for (Annotation t : this.altForms) {
                list = list + t.getCoveredText() + "[" + t.getBegin() + "-" + t.getEnd() + "] ";
            }
            return "min:" + this.min + " max:" + this.max + list;
        }
    }
}

