/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.utils;

import ch.epfl.bbp.DateUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class ConceptFileWriter {
    private ConceptFileWriter() {
    }

    public static void writeConceptFile(File f, Collection<Concept> concepts) throws FileNotFoundException {
        ConceptFileWriter.writeConceptFile(f, concepts, "");
    }

    public static void writeConceptFile(File f, Collection<Concept> concepts, String msg) throws FileNotFoundException {
        PrintWriter w = new PrintWriter(f);
        w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        w.append("<!-- generated by ConceptFileWriter on " + DateUtils.nowToHuman() + " -->\n");
        if (msg != null && msg.length() > 0) {
            w.append("<!--  " + ConceptFileWriter.escape(msg) + " -->\n");
        }
        w.append("<synonym>\n");
        for (Concept c : concepts) {
            w.format("<token canonical=\"%s\" ref_id=\"%s\">\n", ConceptFileWriter.escape(c.canonical), ConceptFileWriter.escape(c.id));
            for (String v : c.variants) {
                w.format("  <variant base=\"%s\" />\n", ConceptFileWriter.escape(v));
            }
            w.append("</token>\n");
        }
        w.append("</synonym>\n");
        w.close();
    }

    private static String escape(Object in) {
        return StringEscapeUtils.escapeXml((String)in.toString());
    }

    public static class Concept {
        String canonical;
        String id;
        Set<String> variants;

        public Concept(String canonical, String id, Set<String> variants) {
            this.canonical = canonical;
            this.id = id;
            this.variants = variants;
        }

        public Set<String> getVariants() {
            return this.variants;
        }

        public Concept addVariant(String variant) {
            if (this.variants == null) {
                this.variants = Sets.newHashSet();
            }
            this.variants.add(variant);
            return this;
        }

        public String getCanonical() {
            return this.canonical;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.id + ":" + this.canonical + " " + Arrays.toString(this.variants.toArray()) + "";
        }
    }
}

