/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.uimafit;

import ch.epfl.bbp.DateUtils;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusCallbackListenerSlf4J
implements StatusCallbackListener {
    private static Logger LOG = LoggerFactory.getLogger(StatusCallbackListenerSlf4J.class);
    int entityCount = 0;
    long size = 0L;
    String name;
    private boolean collectionProcessComplete;
    private long start = System.currentTimeMillis();
    private CollectionProcessingEngine cpe;
    static final DecimalFormat pctFmt = new DecimalFormat("##.##%");

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void initializationComplete() {
        LOG.info("[{}] initializationComplete, took {}s", (Object)this.getName(), (Object)((System.currentTimeMillis() - this.start) / 1000L + ""));
    }

    public synchronized void batchProcessComplete() {
        LOG.info("[{}] batchProcessComplete", (Object)this.getName());
    }

    public synchronized void collectionProcessComplete() {
        if (this.entityCount == 0) {
            LOG.info("[{}] collectionProcessComplete, processed 0 cas", (Object)this.getName());
            return;
        }
        long duration = System.currentTimeMillis() - this.start;
        LOG.info("[{}] collectionProcessComplete, processed {} cas in {}s (avrg. {}ms per CAS)", new Object[]{this.getName(), this.entityCount, duration / 1000L + "", duration / (long)this.entityCount});
        this.collectionProcessComplete = true;
        StringBuffer buf = new StringBuffer();
        ProcessTrace processTrace = this.cpe.getPerformanceReport();
        int totalTime = 0;
        for (ProcessTraceEvent event : processTrace.getEvents()) {
            totalTime += event.getDuration();
        }
        buf.append("\n--PERFORMANCE STATS --------------------------------------------------------------------------------\n");
        if (totalTime > 0) {
            buf.append("      Duration\t      %\t Type           \tComponent Name\n");
            for (ProcessTraceEvent event : processTrace.getEvents()) {
                double pct;
                int eventDuration = event.getDuration();
                if (duration <= 100L || !((pct = (double)eventDuration / (double)totalTime) > 0.005)) continue;
                String pctStr = pctFmt.format(pct);
                buf.append(String.format("%12s", eventDuration) + "ms \t" + String.format("%7s", pctStr) + "\t " + StatusCallbackListenerSlf4J.cropToLength(event.getType(), 15) + "\t" + StatusCallbackListenerSlf4J.cropToLength(event.getComponentName(), 60) + "\n");
            }
        }
        buf.append(String.format("%12s", totalTime) + "ms   TOTAL TIME (" + DateUtils.toHuman((long)totalTime) + ")\n----------------------------------------------------------------------------------------------------\n");
        System.out.println(buf);
    }

    public static String cropToLength(String s, int l) {
        if (l < 1) {
            return null;
        }
        if (s == null || s.length() == 0) {
            return StringUtils.repeat((String)" ", (int)l);
        }
        if (s.length() > l) {
            return s.substring(s.length() - l);
        }
        return s + StringUtils.repeat((String)" ", (int)(l - s.length()));
    }

    public boolean isCollectionProcessComplete() {
        return this.collectionProcessComplete;
    }

    public synchronized void paused() {
        LOG.info("[{}] paused", (Object)this.getName());
    }

    public synchronized void resumed() {
        LOG.info("[{}] resumed", (Object)this.getName());
    }

    public void aborted() {
        LOG.info("[{}] aborted", (Object)this.getName());
    }

    public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        if (aCas == null) {
            int i;
            for (i = 0; i < aStatus.getFailedComponentNames().size(); ++i) {
                LOG.info("[{}] FailedComponentNames", aStatus.getFailedComponentNames().get(i));
            }
            for (i = 0; i < aStatus.getExceptions().size(); ++i) {
                LOG.info("[{}] Exceptions", (Throwable)aStatus.getExceptions().get(i));
            }
            return;
        }
        try {
            ++this.entityCount;
            if (aStatus.isException()) {
                for (int q = 0; q < aStatus.getExceptions().size(); ++q) {
                    Exception e = (Exception)aStatus.getExceptions().get(q);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception io) {
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, "", (Throwable)io);
        }
    }

    public void setCpe(CollectionProcessingEngine cpe) {
        this.cpe = cpe;
    }
}

