/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.testutils;

import ch.epfl.bbp.uima.ae.DotSentenceSplitterAnnotator;
import ch.epfl.bbp.uima.ae.WhitespaceTokenizerAnnotator;
import ch.epfl.bbp.uima.typesystem.To;
import ch.epfl.bbp.uima.utils.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public class UimaTests {
    public static final String TEST_SENTENCE = "Using this calibration procedure, we find that mature granule cells (doublecortin-) contain approximately 40 microm, and newborn granule cells (doublecortin+) contain 0-20 microm calbindin-D28k.";
    public static final String TEST_ABSTRACT = "An automated clean up and concentration method by column switching is described for the assay of mitoxantrone, an antitumour drug in plasma. The system uses a YWG-CN short precolumn for on-line clean up and concentration and a Shimpack CLC-ODS analytical column for separation. Water is used as pretreat mobile phase and 48% methanol in ammonium acetate (0.2 mol/L pH 1.9) is used as analytical mobile phase. The plasma sample is treated with methanol and ultrasonated for 10 min. The supernatant of treated sample is directly injected to precolumn. The recovery of clean up is 85%. The wavelength used for detection is 658 nm and the concentration of detection limit is 6 ng/ml in plasma. The procedure is simple and the method is sensitive.";
    public static final String TEST_DEPENDENCY = "Altogether, our results suggest that NAC might impair the generation of primary immune responses in humans through its inhibitory action on DC.";

    public static JCas getTestCas() throws UIMAException {
        return UimaTests.getTestCas(TEST_SENTENCE);
    }

    public static JCas getTestCas(String text) throws UIMAException {
        JCas jCas = JCasFactory.createJCas();
        TypeSystemDescription ts = TypeSystemDescriptionFactory.createTypeSystemDescription();
        jCas.setDocumentText(text);
        jCas.setDocumentLanguage("en");
        return jCas;
    }

    public static <T extends Annotation> T createAnnot(JCas jCas, Class<T> c, int beg, int end) throws Exception {
        com.google.common.base.Preconditions.checkArgument((beg <= end ? 1 : 0) != 0);
        Constructor<T> ctor = c.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
        Annotation a = (Annotation)ctor.newInstance(jCas, beg, end);
        a.addToIndexes();
        return (T)a;
    }

    public static <T extends Annotation> T createAnnot(JCas jCas, Class<T> c, int beg, int end, String assertCoveredText) throws Exception {
        T annot = UimaTests.createAnnot(jCas, c, beg, end);
        Preconditions.checkEquals(annot.getCoveredText(), assertCoveredText);
        return annot;
    }

    public static void assertResultsContains(Collection<? extends TOP> annotations, String fieldName, Object expected) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        boolean found = false;
        if (annotations.size() == 0) {
            throw new AssertionError((Object)"no annotations found");
        }
        for (TOP tOP : annotations) {
            Method method = tOP.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (expected instanceof Integer) {
                try {
                    int expectedInt = (Integer)expected;
                    int actual = Integer.parseInt((String)method.invoke((Object)tOP, new Object[0]));
                    if (actual != expectedInt) continue;
                    found = true;
                }
                catch (Exception e) {}
                continue;
            }
            if (!(expected instanceof String)) continue;
            String expectedStr = (String)expected;
            String actual = (String)method.invoke((Object)tOP, new Object[0]);
            if (!actual.equals(expectedStr)) continue;
            found = true;
        }
        if (!found) {
            throw new AssertionError((Object)("cannot find field '" + fieldName + "' on collection \n" + To.string(annotations)));
        }
    }

    public static void assertResultsContains(Collection<? extends Annotation> annotations, int begin, int end) {
        if (annotations.size() == 0) {
            throw new AssertionError((Object)"no annotations found");
        }
        for (Annotation annotation : annotations) {
            if (annotation.getBegin() != begin || annotation.getEnd() != end) continue;
            return;
        }
        String msg = "cannot find begin-end '" + begin + "-" + end + "' on collection (have: ";
        for (Annotation annotation : annotations) {
            msg = msg + annotation.getBegin() + "-" + annotation.getEnd() + " ";
        }
        throw new AssertionError((Object)(msg + ")"));
    }

    public static void assertResultsContainsText(Collection<? extends Annotation> annotations, String ... texts) {
        if (annotations.size() == 0) {
            throw new AssertionError((Object)"no annotations found");
        }
        if (annotations.size() != texts.length) {
            throw new AssertionError((Object)("annotation size not matching text size, " + annotations.size() + " vs " + texts.length));
        }
        int i = 0;
        for (Annotation annotation : annotations) {
            if (!annotation.getCoveredText().equals(texts[i])) {
                throw new AssertionError((Object)("Text '" + texts[i] + "' at position " + i + " does not match '" + annotation.getCoveredText() + "'"));
            }
            ++i;
        }
    }

    public static void assertResultsCovers(Collection<? extends Annotation> annotations, String textToBeCovered) {
        boolean found = false;
        for (Annotation annotation : annotations) {
            if (!annotation.getCoveredText().equals(textToBeCovered)) continue;
            found = true;
        }
        if (!found) {
            throw new AssertionError((Object)("cannot find text '" + textToBeCovered + "' on collection \n" + To.string(annotations)));
        }
    }

    public static JCas getTokenizedTestCas(String text) throws UIMAException, IOException {
        JCas testCas = UimaTests.getTestCas(text);
        AnalysisEngine ss = AnalysisEngineFactory.createEngine(DotSentenceSplitterAnnotator.class, (Object[])new Object[0]);
        AnalysisEngine wt = AnalysisEngineFactory.createEngine(WhitespaceTokenizerAnnotator.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((JCas)testCas, (AnalysisEngine[])new AnalysisEngine[]{ss, wt});
        return testCas;
    }

    public static JCas getTokenizedTestCas() throws UIMAException, IOException {
        return UimaTests.getTokenizedTestCas(TEST_SENTENCE);
    }

    public static void assertContains(JCas jCas, Class<? extends Annotation> annot, int expectedCnt) {
        if (expectedCnt == 0) {
            com.google.common.base.Preconditions.checkArgument((!JCasUtil.exists((JCas)jCas, annot) ? 1 : 0) != 0, (String)"assertContains %s annotations of type %s, but found some ", (Object[])new Object[]{expectedCnt, annot.getSimpleName()});
        } else {
            Preconditions.checkEquals(expectedCnt, JCasUtil.select((JCas)jCas, annot).size(), "assertContains " + expectedCnt + " annotations of type " + annot.getSimpleName() + ", but found " + JCasUtil.select((JCas)jCas, annot).size());
        }
    }
}

