/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.io.LineReader;
import ch.epfl.bbp.uima.BlueUima;
import ch.epfl.bbp.uima.types.Keep;
import ch.epfl.bbp.uima.utils.Preconditions;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class StopwordFilterAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="caseSensitive", defaultValue={"false"}, description="If true, tokens are not normalized to lowercase before string comparisions")
    private boolean caseSensitive;
    @ConfigurationParameter(name="inputFile", mandatory=false, description="path to the stopword list. If none is provided, the stopword list of Mallet is used")
    private String stopwordsFilePath;
    private Set<String> stopList = Sets.newHashSet();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            if (this.stopwordsFilePath == null) {
                this.stopwordsFilePath = BlueUima.BLUE_UTILS_ROOT + "src/main/resources/" + "stoplists/mallet_stopwords_en.txt";
            }
            Preconditions.checkFileExists(this.stopwordsFilePath);
            for (String line : LineReader.linesFrom((String)this.stopwordsFilePath)) {
                if (this.caseSensitive) {
                    this.stopList.add(line.trim());
                    continue;
                }
                this.stopList.add(line.toLowerCase().trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection keeps = JCasUtil.select((JCas)jCas, Keep.class);
        Keep[] array = keeps.toArray(new Keep[keeps.size()]);
        for (int i = 0; i < array.length; ++i) {
            String txt = array[i].getNormalizedText();
            if (!this.caseSensitive) {
                txt = txt.toLowerCase();
            }
            if (!this.stopList.contains(txt)) continue;
            array[i].removeFromIndexes();
        }
    }
}

