/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.Keep;
import de.julielab.jules.types.Token;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Keep"}, outputs={"ch.epfl.bbp.uima.types.Keep"})
public class SimpleNormalizerAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="caseSensitive", defaultValue={"false"}, description="If true, tokens are not normalized to lowercase before string comparisions")
    private boolean caseSensitive;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Keep k : JCasUtil.select((JCas)jCas, Keep.class)) {
            Annotation a = k.getEnclosedAnnot();
            String normalized = null;
            if (a instanceof Token) {
                normalized = ((Token)a).getLemmaStr();
            }
            if (normalized == null) {
                normalized = a.getCoveredText().trim();
            }
            if (!this.caseSensitive) {
                normalized = normalized.toLowerCase();
            }
            k.setNormalizedText(normalized);
        }
    }
}

