/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.types.DocumentBlock;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.DocumentBlock"}, outputs={"ch.epfl.bbp.uima.types.DocumentBlock"})
public class SectionRegexAnnotator
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(SectionRegexAnnotator.class);
    private final LinkedHashMap<String, Pattern> patterns = Maps.newLinkedHashMap();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.patterns.put("CITATION", Pattern.compile("^Citation(:|s) "));
        this.patterns.put("DOWNLOADED", Pattern.compile("^Downloaded from$"));
        this.patterns.put("DOWNLOADED_ON", Pattern.compile("on (April|August|December|February|January|July|June|March|May|November|October|September)"));
        this.patterns.put("URL_ON_A_LINE", Pattern.compile("^(http://)?(\\w{1,20}\\.){1,3}(com|net|edu|org|ch|de).{0,50}$"));
        this.patterns.put("RECEIVED", Pattern.compile("^.{0,20}[Rr]eceived.{0,20}(19[56789]|20[01])\\d.{0,10}[Aa]ccepted.{5,1200}"));
        this.patterns.put("ACKNOWLEDGEMENTS", Pattern.compile("(^A(CKNOWLEDGMENTS|cknowledgments))|(This (work|study) (is|was) supported by)|([Ss]upported.{1,15} [gG]rant)|We (would like to)? thank"));
        this.patterns.put("EMAIL", Pattern.compile("\\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4}\\b"));
        this.patterns.put("REFERENCES", Pattern.compile("^(B(ibliography|IBLIOGRAPHY)|LITERATURE CITED|References|REFERENCES)"));
        this.patterns.put("MAT_MET", Pattern.compile("^(Materials? and )?Methods", 2));
        this.patterns.put("SUMMARY", Pattern.compile("^S(ummary|UMMARY)"));
        this.patterns.put("FIGURE", Pattern.compile("^F(IG|ig)(URE|ure)?.{0,4}\\d"));
        this.patterns.put("TABLE", Pattern.compile("^table.{0,5}(\\d|I+)", 2));
        this.patterns.put("ABSTRACT", Pattern.compile("(^Abstract|ABSTRACT)"));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (!BlueCasUtil.isEmptyText(jCas)) {
            for (DocumentBlock block : JCasUtil.select((JCas)jCas, DocumentBlock.class)) {
                String txt = block.getCoveredText().replaceAll("\n", "");
                for (Map.Entry<String, Pattern> element : this.patterns.entrySet()) {
                    if (!element.getValue().matcher(txt).find()) continue;
                    block.setLabel(element.getKey());
                }
            }
        }
    }
}

