/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.StringUtils;
import ch.epfl.bbp.io.TsvUtils;
import ch.epfl.bbp.uima.BlueCasUtil;
import ch.epfl.bbp.uima.BlueUima;
import ch.epfl.bbp.uima.types.DocumentBlock;
import ch.epfl.bbp.uima.utils.SnowballStemmer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.DocumentElement"})
public class SectionAnnotator
extends JCasAnnotator_ImplBase {
    Logger LOG = LoggerFactory.getLogger(SectionAnnotator.class);
    int totCnt = 0;
    int foundCnt = 0;
    private Map<Integer, String> categories;
    private Map<String, Integer> sectionTitles;
    private static SnowballStemmer stemmer = new SnowballStemmer();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            String root = BlueUima.BLUE_UTILS_ROOT + "src/main/resources/" + "sections/";
            this.categories = TsvUtils.loadIntString((InputStream)new FileInputStream(root + "categories.tsv"), (boolean)true);
            Preconditions.checkArgument((this.categories.size() > 5 ? 1 : 0) != 0);
            this.sectionTitles = TsvUtils.loadStringInt((InputStream)new FileInputStream(root + "titles_stemmed.tsv"), (boolean)true);
            Preconditions.checkArgument((this.sectionTitles.size() > 30 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String trigger;
        int pmId = BlueCasUtil.getHeaderIntDocId(jCas);
        ++this.totCnt;
        HashSet strategyUppercase = Sets.newHashSet();
        HashSet strategyExactMatch = Sets.newHashSet();
        HashSet strategyStartsWith = Sets.newHashSet();
        LinkedHashMap blocksCache = Maps.newLinkedHashMap();
        for (DocumentBlock block : JCasUtil.select((JCas)jCas, DocumentBlock.class)) {
            void var9_10;
            String string = SectionAnnotator.cleanBlockText(block.getCoveredText());
            if (string == null) {
                String string2 = "";
            }
            blocksCache.put(block, var9_10);
            for (Map.Entry<String, Integer> ent : this.sectionTitles.entrySet()) {
                trigger = ent.getKey();
                int category = ent.getValue();
                if (var9_10.startsWith(trigger.toUpperCase())) {
                    strategyUppercase.add(category);
                }
                if (var9_10.toLowerCase().equals(trigger)) {
                    strategyExactMatch.add(category);
                }
                if (!var9_10.toLowerCase().startsWith(trigger)) continue;
                strategyStartsWith.add(category);
            }
        }
        this.LOG.trace("STATS: pmid:{}\tUC:{}\tEQ:{}\tST:{}", new Object[]{pmId, strategyUppercase.size(), strategyExactMatch.size(), strategyStartsWith.size()});
        boolean found = false;
        if (strategyUppercase.size() > 2) {
            this.LOG.trace("TAKING STRATEGY UP(PERCASE) at cut " + strategyUppercase.size());
            found = true;
            for (Map.Entry entry : blocksCache.entrySet()) {
                for (Map.Entry<String, Integer> ent : this.sectionTitles.entrySet()) {
                    trigger = ent.getKey();
                    if (!((String)entry.getValue()).startsWith(trigger.toUpperCase())) continue;
                    String sectionIdStr = this.categories.get(ent.getValue());
                    ((DocumentBlock)entry.getKey()).setLabel(sectionIdStr);
                }
            }
        } else if (strategyExactMatch.size() >= 4) {
            this.LOG.trace("TAKING STRATEGY EX(ACT MATCH) at cut " + strategyExactMatch.size());
            found = true;
            for (Map.Entry entry : blocksCache.entrySet()) {
                for (Map.Entry<String, Integer> ent : this.sectionTitles.entrySet()) {
                    trigger = ent.getKey();
                    if (!((String)entry.getValue()).toLowerCase().equals(trigger)) continue;
                    String sectionIdStr = this.categories.get(ent.getValue());
                    ((DocumentBlock)entry.getKey()).setLabel(sectionIdStr);
                }
            }
        } else if (strategyStartsWith.size() >= 5) {
            this.LOG.trace("TAKING STRATEGY ST(ART WITH) at cut " + strategyStartsWith.size());
            found = true;
            for (Map.Entry entry : blocksCache.entrySet()) {
                for (Map.Entry<String, Integer> ent : this.sectionTitles.entrySet()) {
                    trigger = ent.getKey();
                    if (!((String)entry.getValue()).toLowerCase().startsWith(trigger)) continue;
                    String sectionIdStr = this.categories.get(ent.getValue());
                    ((DocumentBlock)entry.getKey()).setLabel(sectionIdStr);
                }
            }
        }
        if (found) {
            ++this.foundCnt;
        } else {
            this.LOG.trace("COULD NOT LABEL: " + pmId + " ********************************");
            for (DocumentBlock documentBlock : JCasUtil.select((JCas)jCas, DocumentBlock.class)) {
                String cleanedBlockText = SectionAnnotator.cleanBlockText(documentBlock.getCoveredText());
                this.LOG.trace("{}\t***{}", (Object)cleanedBlockText, (Object)documentBlock.getCoveredText());
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.LOG.trace("found\t{}\ttotal\t{}", (Object)this.foundCnt, (Object)this.totCnt);
    }

    public static String cleanBlockText(String text) {
        if (text == null || text.length() < 6) {
            return null;
        }
        if (text.length() < 6) {
            return null;
        }
        int firstReturn = text.indexOf("\n");
        if (firstReturn > -1) {
            text = text.substring(0, firstReturn);
        }
        text = text.replaceAll(" +", " ").trim();
        if ((text = text.replaceAll("^\\d*", "").replaceAll("\t", " ").trim()).length() > 0 && text.charAt(0) == '.') {
            text = text.substring(1).trim();
        }
        double letters = 0.0;
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isLetter(text.charAt(i))) continue;
            letters += 1.0;
        }
        if (letters / ((double)text.length() + 0.0) < 0.5) {
            return null;
        }
        String stemmed = "";
        for (String token : text.trim().split(" ")) {
            stemmed = stemmed + stemmer.stem(token) + " ";
        }
        String snippet = StringUtils.snippetize((String)stemmed.trim(), (int)30);
        return snippet.trim();
    }
}

