/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.Keep;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class KeepsWriter
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputFile")
    private String outputFile;
    private static final String PARAM_WRITE_DASHES = "writeDashes";
    @ConfigurationParameter(name="writeDashes", mandatory=false, defaultValue={"false"}, description="Whether to replace all spaces in (multi)words with dashes ('_')")
    private boolean writeDashes;
    private PrintWriter writer;
    private int i = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.outputFile))));
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ArrayList words = Lists.newArrayList();
        for (Keep k : JCasUtil.select((JCas)jCas, Keep.class)) {
            if (this.writeDashes) {
                words.add(k.getNormalizedText().replaceAll(" ", "_"));
                continue;
            }
            words.add(k.getNormalizedText());
        }
        this.writer.println(StringUtils.join((Collection)words, (String)" "));
        if (this.i++ % 1000 == 0) {
            this.writer.flush();
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        IOUtils.closeQuietly((Writer)this.writer);
    }
}

