/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.EtAlInlineReference;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={"ch.epfl.bbp.uima.types.EtAlInlineReference"})
public class EtAlAnnotator
extends JCasAnnotator_ImplBase {
    private static Logger LOG = LoggerFactory.getLogger(EtAlAnnotator.class);
    private final List<Pattern> patterns = Lists.newArrayList();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.patterns.add(Pattern.compile("\\([A-Z][^(]{4,500}(19[56789]|20[01])\\d[abcde]?\\)"));
        this.patterns.add(Pattern.compile("\\([^()]{0,100}(et\\.? al)([^()]+)(19[56789]|20[01])\\d[abcde]?\\)"));
        this.patterns.add(Pattern.compile("([A-Z]\\w+ and )?[A-Z]\\w+ (et\\.? al\\.?)? ?\\((19[56789]|20[01])\\d[abcde]?\\)"));
        this.patterns.add(Pattern.compile("\\([^(]{0,100}(et\\.? al\\.?)[^(]{0,100}\\)"));
        this.patterns.add(Pattern.compile("[A-Z]\\w{2,50} (et\\.? al\\.?) ?\\((19[56789]|20[01])\\d\\)"));
        this.patterns.add(Pattern.compile("et\\.? al\\.?"));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String txt = jCas.getDocumentText();
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(txt);
            while (matcher.find()) {
                new EtAlInlineReference(jCas, matcher.start(), matcher.end()).addToIndexes();
            }
        }
    }
}

