/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.filter;

import ch.epfl.bbp.uima.types.Keep;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@TypeCapability(inputs={"ch.epfl.bbp.uima.types.Keep"}, outputs={})
public class AnnotationFilterAnnotator
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="annotationClasses", mandatory=true, description="an array with the full name of each annotation classes")
    private String[] annotationClasses;
    private Set<Class> annotationClassesList = new HashSet<Class>();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        for (String annotationClass : this.annotationClasses) {
            try {
                Class<?> classz = Class.forName(annotationClass);
                Preconditions.checkNotNull(classz, (Object)("could not load class " + annotationClass));
                this.annotationClassesList.add(classz);
            }
            catch (Exception e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection keeps = JCasUtil.select((JCas)jCas, Keep.class);
        Keep[] array = keeps.toArray(new Keep[keeps.size()]);
        for (int i = 0; i < array.length; ++i) {
            Class<?> classz = array[i].getEnclosedAnnot().getClass();
            if (!this.annotationClassesList.contains(classz)) continue;
            array[i].removeFromIndexes();
        }
    }
}

