/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.ResourceHelper;
import ch.epfl.bbp.io.IOUtils;
import ch.epfl.bbp.uima.cr.AbstractFileReader;
import ch.epfl.bbp.uima.io.DirectoryIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class ZipXmiCollectionReader
extends AbstractFileReader {
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    public static final String PARAM_XML_SCHEME = "xmlSchemeName";
    @ConfigurationParameter(name="xmlSchemeName", defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' and 'XCAS'")
    private String xmlScheme;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            File dir = ResourceHelper.getFile((String)this.inputDir);
            this.fileIterator = DirectoryIterator.get(this.directoryIterator, dir, "zip", this.isRecursive);
        }
        catch (Exception e) {
            throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{this.inputDir});
        }
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        File currentZipFile = (File)this.fileIterator.next();
        ZipXmiCollectionReader.deserialize(currentZipFile, jCas, this.xmlScheme);
    }

    public static void deserialize(File currentZipFile, JCas jCas, String _xmlScheme) throws IOException {
        try (InputStream inputStream = IOUtils.unzipUniqueFileAsStream((File)currentZipFile);){
            if (_xmlScheme.equals(XMI)) {
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            } else {
                XCASDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            }
        }
    }
}

