/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.uima.cr.AbstractFileReader;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class XCollectionReader
extends AbstractFileReader {
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    public static final String PARAM_XML_SCHEME = "xmlSchemeName";
    @ConfigurationParameter(name="xmlSchemeName", defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' and 'XCAS'")
    private String xmlScheme;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        Preconditions.checkArgument((this.xmlScheme.equals(XMI) || this.xmlScheme.equals(XCAS) ? 1 : 0) != 0);
        this.fileExtensionFilter = this.xmlScheme.toLowerCase();
        super.initialize(context);
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        File currentFile = (File)this.fileIterator.next();
        try (FileInputStream inputStream = new FileInputStream(currentFile);){
            if (this.xmlScheme.equals(XMI)) {
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            } else {
                XCASDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
            }
        }
    }
}

