/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.ResourceHelper;
import ch.epfl.bbp.io.LineReader;
import com.google.common.base.Preconditions;
import de.julielab.jules.types.Header;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class TextLineReader
extends JCasCollectionReader_ImplBase {
    Logger LOG = LoggerFactory.getLogger(TextLineReader.class);
    public static final String COMPONENT_ID = TextLineReader.class.getName();
    public static final String PARAM_SPLIT_MODE = "splitMode";
    @ConfigurationParameter(name="inputFile", mandatory=true, defaultValue={"pear_resources/sample_file.txt"}, description="path to text file")
    private String inputFile;
    @ConfigurationParameter(name="splitMode", mandatory=true, defaultValue={"1"}, description="how to split for new CAS. Values are 1 (split on each new line, default), 2 (split on empty new line)")
    private Integer splitMode;
    private Iterator<String> lineIt;
    private int docId;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.docId = 0;
        this.LOG.debug("inputFile is " + this.inputFile);
        try {
            InputStream inputFileIs = ResourceHelper.getInputStream((String)this.inputFile);
            Preconditions.checkArgument((inputFileIs != null ? 1 : 0) != 0);
            this.lineIt = new LineReader(inputFileIs).iterator();
        }
        catch (Exception e) {
            throw new ResourceInitializationException("no_resource_for_parameters", new Object[]{"inputFile: " + this.inputFile});
        }
        if (this.splitMode == null || this.splitMode < 1 || this.splitMode > 2) {
            throw new ResourceInitializationException("resource_data_not_valid", new Object[]{this.splitMode, PARAM_SPLIT_MODE});
        }
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        if (this.splitMode == 1) {
            String line = this.lineIt.next();
            jcas.setDocumentText(line.trim());
        } else {
            String line;
            String text = "";
            while (this.lineIt.hasNext() && (line = this.lineIt.next()).length() != 0) {
                text = text + "\n" + line;
            }
            jcas.setDocumentText(text.trim());
        }
        Header header = new Header(jcas);
        header.setDocId(++this.docId + "");
        header.setComponentId(COMPONENT_ID);
        header.addToIndexes();
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.lineIt.hasNext();
    }

    public Progress[] getProgress() {
        return null;
    }
}

