/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import de.julielab.jules.types.Header;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class TextArrayReader
extends JCasCollectionReader_ImplBase {
    Logger LOG = LoggerFactory.getLogger(TextArrayReader.class);
    public static final String COMPONENT_ID = TextArrayReader.class.getName();
    @ConfigurationParameter(name="input", mandatory=true, description="a array of string, to be processed")
    private String[] inputArray;
    private int docId;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.docId = 0;
        this.LOG.debug("inputArray is {}", (Object)StringUtils.join((Object[])this.inputArray));
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        jcas.setDocumentText(this.inputArray[this.docId]);
        Header header = new Header(jcas);
        header.setDocId(++this.docId + "");
        header.setComponentId(COMPONENT_ID);
        header.addToIndexes();
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.docId < this.inputArray.length;
    }

    public Progress[] getProgress() {
        return null;
    }
}

