/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.bbp.uima.cr;

import ch.epfl.bbp.uima.cr.OneDocPerLineReader;
import ch.epfl.bbp.uima.utils.Preconditions;
import de.julielab.jules.types.Header;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;

@TypeCapability(outputs={"de.julielab.jules.types.Header"})
public class OneDocPerLineReader2
extends OneDocPerLineReader {
    @Override
    public void getNext(JCas jCas) throws IOException, CollectionException {
        String[] split = this.nextLine.split("\t");
        Preconditions.checkEquals(3, split.length, "pmid" + split[0]);
        String pmid = StringEscapeUtils.unescapeCsv((String)split[0]).replaceAll("\"", "");
        String title = StringEscapeUtils.unescapeCsv((String)split[1]);
        String txt = StringEscapeUtils.unescapeCsv((String)split[2]);
        Header header = new Header(jCas);
        header.setDocId(pmid);
        header.setTitle(title);
        header.addToIndexes();
        jCas.setDocumentText(title + (title.endsWith(".") ? " " : ". ") + txt);
        jCas.setDocumentLanguage("en");
    }
}

